/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

final class AsyncReduce<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final BiFunction<T, T, T> reducer;

    AsyncReduce(AsyncEnumerable<T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new ReduceEnumerator<T>(this.source.enumerator(), this.reducer);
    }

    static final class ReduceEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final BiFunction<T, T, T> reducer;
        boolean once;
        boolean moveNextOnce;
        T accumulator;
        T result;
        CompletableFuture<Boolean> completable;
        volatile boolean cancelled;

        ReduceEnumerator(AsyncEnumerator<T> source, BiFunction<T, T, T> reducer) {
            this.source = source;
            this.reducer = reducer;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.moveNextOnce) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.moveNextOnce = true;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextSource();
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }

        void nextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.accumulator = null;
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                if (this.once) {
                    this.accumulator = this.reducer.apply(this.accumulator, this.source.current());
                } else {
                    this.once = true;
                    this.accumulator = this.source.current();
                }
                this.nextSource();
            } else {
                this.result = this.accumulator;
                this.accumulator = null;
                this.completable.complete(this.once);
            }
        }
    }
}

