/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

final class AsyncReduceWith<T, R>
implements AsyncEnumerable<R> {
    final AsyncEnumerable<T> source;
    final Supplier<R> initialSupplier;
    final BiFunction<R, T, R> reducer;

    AsyncReduceWith(AsyncEnumerable<T> source, Supplier<R> initialSupplier, BiFunction<R, T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public AsyncEnumerator<R> enumerator() {
        return new ReduceWithEnumerator<T, R>(this.source.enumerator(), this.reducer, this.initialSupplier.get());
    }

    static final class ReduceWithEnumerator<T, R>
    extends AtomicInteger
    implements AsyncEnumerator<R>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final BiFunction<R, T, R> reducer;
        R accumulator;
        R result;
        boolean once;
        CompletableFuture<Boolean> completable;
        volatile boolean cancelled;

        ReduceWithEnumerator(AsyncEnumerator<T> source, BiFunction<R, T, R> reducer, R accumulator) {
            this.source = source;
            this.reducer = reducer;
            this.accumulator = accumulator;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.once) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.once = true;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextSource();
            return cf;
        }

        void nextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public R current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.accumulator = null;
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.accumulator = this.reducer.apply(this.accumulator, this.source.current());
                this.nextSource();
            } else {
                this.result = this.accumulator;
                this.accumulator = null;
                this.completable.complete(true);
            }
        }
    }
}

