/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;

final class AsyncRepeat<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final long times;
    final BooleanSupplier stop;

    AsyncRepeat(AsyncEnumerable<T> source, long times, BooleanSupplier stop) {
        this.source = source;
        this.times = times;
        this.stop = stop;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new RepeatEnumerator<T>(this.source, this.times, this.stop);
    }

    static final class RepeatEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerable<T> source;
        long times;
        final BooleanSupplier stop;
        final AtomicReference<AsyncEnumerator<T>> current;
        T result;
        CompletableFuture<Boolean> completable;

        RepeatEnumerator(AsyncEnumerable<T> source, long times, BooleanSupplier stop) {
            this.source = source;
            this.current = new AtomicReference<AsyncEnumerator<T>>(source.enumerator());
            this.times = times;
            this.stop = stop;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextItem();
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.current);
        }

        void nextItem() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.current.get().moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.result = null;
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.result = this.current.getPlain().current();
                this.completable.complete(true);
            } else if (--this.times <= 0L || this.stop.getAsBoolean()) {
                this.result = null;
                this.completable.complete(false);
            } else if (AsyncEnumeratorHelper.replace(this.current, this.source.enumerator())) {
                this.nextItem();
            }
        }
    }
}

