/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class AsyncRepeatCallable<T>
implements AsyncEnumerable<T> {
    final Callable<? extends T> callable;

    AsyncRepeatCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new RepeatCallableEnumerator<T>(this.callable);
    }

    static final class RepeatCallableEnumerator<T>
    implements AsyncEnumerator<T> {
        final Callable<? extends T> callable;
        T result;

        RepeatCallableEnumerator(Callable<? extends T> callable) {
            this.callable = callable;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            try {
                this.result = this.callable.call();
            }
            catch (Exception ex) {
                return CompletableFuture.failedStage(ex);
            }
            return AsyncEnumerable.TRUE;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
        }
    }
}

