/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

final class AsyncRetry<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final long times;
    final Predicate<? super Throwable> predicate;

    AsyncRetry(AsyncEnumerable<T> source, long times, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.times = times;
        this.predicate = predicate;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new RetryEnumerator<T>(this.source, this.times, this.predicate);
    }

    static final class RetryEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerable<T> source;
        long times;
        final Predicate<? super Throwable> predicate;
        final AtomicReference<AsyncEnumerator<T>> current;
        T result;
        CompletableFuture<Boolean> completable;

        RetryEnumerator(AsyncEnumerable<T> source, long times, Predicate<? super Throwable> predicate) {
            this.source = source;
            this.current = new AtomicReference<AsyncEnumerator<T>>(source.enumerator());
            this.times = times;
            this.predicate = predicate;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextItem();
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.current);
        }

        void nextItem() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.current.get().moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                if (this.times-- <= 0L || !this.predicate.test(throwable)) {
                    this.result = null;
                    this.completable.completeExceptionally(throwable);
                } else if (AsyncEnumeratorHelper.replace(this.current, this.source.enumerator())) {
                    this.nextItem();
                }
                return;
            }
            if (aBoolean.booleanValue()) {
                this.result = this.current.getPlain().current();
                this.completable.complete(true);
            } else {
                this.result = null;
                this.completable.complete(false);
            }
        }
    }
}

