/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class AsyncRetryWhen<T, S>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Supplier<S> stateSupplier;
    final BiFunction<? super S, ? super Throwable, ? extends CompletionStage<Boolean>> completer;

    public AsyncRetryWhen(AsyncEnumerable<T> source, Supplier<S> stateSupplier, BiFunction<? super S, ? super Throwable, ? extends CompletionStage<Boolean>> completer) {
        this.source = source;
        this.stateSupplier = stateSupplier;
        this.completer = completer;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new RetryWhenEnumerator<T, S>(this.source, this.stateSupplier.get(), this.completer);
    }

    static final class RetryWhenEnumerator<T, S>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerable<T> source;
        final S state;
        final BiFunction<? super S, ? super Throwable, ? extends CompletionStage<Boolean>> completer;
        final AtomicReference<AsyncEnumerator<T>> current;
        T result;
        CompletableFuture<Boolean> completable;

        RetryWhenEnumerator(AsyncEnumerable<T> source, S state, BiFunction<? super S, ? super Throwable, ? extends CompletionStage<Boolean>> completer) {
            this.source = source;
            this.state = state;
            this.completer = completer;
            this.current = new AtomicReference<AsyncEnumerator<T>>(source.enumerator());
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextItem();
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        void nextItem() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.current.get().moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.current);
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.result = null;
                this.completer.apply(this.state, throwable).whenComplete(this::acceptCompleter);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.result = this.current.getPlain().current();
                this.completable.complete(true);
            } else {
                this.result = null;
                this.completable.complete(false);
            }
        }

        void acceptCompleter(Boolean shouldRetry, Throwable throwable) {
            if (throwable != null) {
                this.result = null;
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (shouldRetry.booleanValue()) {
                if (AsyncEnumeratorHelper.replace(this.current, this.source.enumerator())) {
                    this.nextItem();
                }
            } else {
                this.completable.complete(false);
            }
        }
    }
}

