/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

final class AsyncSkip<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> upstream;
    final long n;

    AsyncSkip(AsyncEnumerable<T> upstream, long n) {
        this.upstream = upstream;
        this.n = n;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new SkipEnumerator<T>(this.upstream.enumerator(), this.n);
    }

    static final class SkipEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        long n;
        CompletableFuture<Boolean> cf;

        SkipEnumerator(AsyncEnumerator<T> source, long n) {
            this.source = source;
            this.n = n + 1L;
            this.cf = new CompletableFuture();
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.n > 0L) {
                CompletableFuture<Boolean> nx = this.cf;
                if (this.getAndIncrement() == 0) {
                    do {
                        this.source.moveNext().whenComplete(this);
                    } while (this.decrementAndGet() != 0);
                }
                return nx;
            }
            return this.source.moveNext();
        }

        @Override
        public T current() {
            return this.source.current();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            CompletableFuture<Boolean> nx = this.cf;
            if (throwable != null) {
                this.cf = null;
                nx.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                if (--this.n <= 0L) {
                    this.cf = null;
                    nx.complete(true);
                } else {
                    this.moveNext();
                }
            } else {
                this.cf = null;
                nx.complete(false);
            }
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }
    }
}

