/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

final class AsyncSkipLast<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final int n;

    AsyncSkipLast(AsyncEnumerable<T> source, int n) {
        this.source = source;
        this.n = n;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new SkipLastEnumerator<T>(this.source.enumerator(), this.n);
    }

    static final class SkipLastEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final ArrayDeque<T> deque;
        final int n;
        T result;
        CompletableFuture<Boolean> completable;
        volatile boolean cancelled;

        SkipLastEnumerator(AsyncEnumerator<T> source, int n) {
            this.source = source;
            this.n = n;
            this.deque = new ArrayDeque();
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextSource();
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        void nextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.deque.clear();
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                if (this.n == this.deque.size()) {
                    this.result = this.deque.poll();
                    this.deque.offer(this.source.current());
                    this.completable.complete(true);
                } else {
                    this.deque.offer(this.source.current());
                    this.nextSource();
                }
            } else {
                this.deque.clear();
                this.completable.complete(false);
            }
        }
    }
}

