/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

final class AsyncSubscribeOn<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Executor executor;

    AsyncSubscribeOn(AsyncEnumerable<T> source, Executor executor) {
        this.source = source;
        this.executor = executor;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        SubscribeOnEnumerator<T> en = new SubscribeOnEnumerator<T>(this.source);
        this.executor.execute(en);
        return en;
    }

    static final class SubscribeOnEnumerator<T>
    implements AsyncEnumerator<T>,
    Runnable {
        final CompletableFuture<AsyncEnumerator<T>> source;
        final AsyncEnumerable<T> upstream;

        SubscribeOnEnumerator(AsyncEnumerable<T> upstream) {
            this.upstream = upstream;
            this.source = new CompletableFuture();
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            AsyncEnumerator en = this.source.getNow(null);
            if (en != null) {
                return en.moveNext();
            }
            return this.source.thenCompose(AsyncEnumerator::moveNext);
        }

        @Override
        public T current() {
            AsyncEnumerator en = this.source.getNow(null);
            return en != null ? (T)en.current() : null;
        }

        @Override
        public void run() {
            AsyncEnumerator<T> en = this.upstream.enumerator();
            if (!this.source.complete(en)) {
                en.cancel();
            }
        }

        @Override
        public void cancel() {
            AsyncEnumerator en;
            if (!this.source.completeExceptionally(new CancellationException()) && (en = (AsyncEnumerator)this.source.getNow(null)) != null) {
                en.cancel();
            }
        }
    }
}

