/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class AsyncSumLong<T>
implements AsyncEnumerable<Long> {
    final AsyncEnumerable<T> source;
    final Function<? super T, ? extends Number> selector;

    AsyncSumLong(AsyncEnumerable<T> source, Function<? super T, ? extends Number> selector) {
        this.source = source;
        this.selector = selector;
    }

    @Override
    public AsyncEnumerator<Long> enumerator() {
        return new SumLongEnumerator<T>(this.source.enumerator(), this.selector);
    }

    static final class SumLongEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<Long>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Function<? super T, ? extends Number> selector;
        boolean hasValue;
        long sum;
        Long result;
        boolean done;
        CompletableFuture<Boolean> cf;
        volatile boolean cancelled;

        SumLongEnumerator(AsyncEnumerator<T> source, Function<? super T, ? extends Number> selector) {
            this.source = source;
            this.selector = selector;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.done) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.cf = new CompletableFuture();
            this.collectSource();
            return this.cf;
        }

        @Override
        public Long current() {
            return this.result;
        }

        void collectSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.done = true;
                this.cf.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.sum += this.selector.apply(this.source.current()).longValue();
                this.hasValue = true;
                this.collectSource();
            } else {
                this.done = true;
                if (this.hasValue) {
                    this.result = this.sum;
                    this.cf.complete(true);
                } else {
                    this.cf.complete(false);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }
    }
}

