/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

final class AsyncSwitchIfEmpty<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final AsyncEnumerable<T> fallback;

    AsyncSwitchIfEmpty(AsyncEnumerable<T> source, AsyncEnumerable<T> fallback) {
        this.source = source;
        this.fallback = fallback;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new SwitchIfEmptyEnumerator<T>(this.source.enumerator(), this.fallback);
    }

    static final class SwitchIfEmptyEnumerator<T>
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AtomicReference<AsyncEnumerator<T>> source;
        AsyncEnumerable<T> fallback;
        CompletableFuture<Boolean> completable;
        T result;
        boolean hasValue;

        SwitchIfEmptyEnumerator(AsyncEnumerator<T> source, AsyncEnumerable<T> fallback) {
            this.source = new AtomicReference<AsyncEnumerator<T>>(source);
            this.fallback = fallback;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.source.getPlain().moveNext().whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.source);
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                if (!this.hasValue) {
                    this.hasValue = true;
                }
                this.result = this.source.getPlain().current();
                this.completable.complete(true);
            } else if (this.hasValue) {
                this.completable.complete(false);
            } else {
                this.hasValue = true;
                AsyncEnumerator<T> fb = this.fallback.enumerator();
                this.fallback = null;
                if (AsyncEnumeratorHelper.replace(this.source, fb)) {
                    fb.moveNext().whenComplete(this);
                }
            }
        }
    }
}

