/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;

final class AsyncTake<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> upstream;
    final long n;

    AsyncTake(AsyncEnumerable<T> upstream, long n) {
        this.upstream = upstream;
        this.n = n;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new TakeEnumerator<T>(this.upstream.enumerator(), this.n);
    }

    static final class TakeEnumerator<T>
    implements AsyncEnumerator<T> {
        final AsyncEnumerator<T> source;
        long n;

        TakeEnumerator(AsyncEnumerator<T> source, long n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.n-- <= 0L) {
                this.source.cancel();
                return AsyncEnumerable.FALSE;
            }
            return this.source.moveNext();
        }

        @Override
        public T current() {
            return this.source.current();
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }
    }
}

