/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

final class AsyncTakeUntil<T, U>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final AsyncEnumerable<U> other;

    AsyncTakeUntil(AsyncEnumerable<T> source, AsyncEnumerable<U> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        AsyncEnumerator<U> otherEnum = this.other.enumerator();
        TakeUntilEnumerator main = new TakeUntilEnumerator(otherEnum);
        otherEnum.moveNext().whenComplete(main::acceptOther);
        AsyncEnumeratorHelper.replace(main.source, this.source.enumerator());
        return main;
    }

    static final class TakeUntilEnumerator<T, U>
    extends AtomicReference<CompletableFuture<Boolean>>
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<U> other;
        final AtomicReference<AsyncEnumerator<T>> source;
        CompletableFuture<Boolean> current;
        static final TerminalCompletableFuture STOP = new TerminalCompletableFuture();

        TakeUntilEnumerator(AsyncEnumerator<U> other) {
            this.other = other;
            this.source = new AtomicReference();
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            AsyncEnumerator<T> en;
            CompletableFuture<Boolean> next;
            CompletableFuture curr;
            do {
                if ((curr = (CompletableFuture)this.get()) instanceof TerminalCompletableFuture) {
                    this.other.cancel();
                    return curr;
                }
                next = new CompletableFuture<Boolean>();
                en = this.source.getAcquire();
            } while (!this.compareAndSet(curr, next));
            this.current = next;
            en.moveNext().whenComplete(this);
            return next;
        }

        @Override
        public T current() {
            return this.source.getPlain().current();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.other.cancel();
                this.current.completeExceptionally(throwable);
                return;
            }
            if (!aBoolean.booleanValue()) {
                this.other.cancel();
            }
            this.current.complete(aBoolean);
        }

        public void acceptOther(Boolean aBoolean, Throwable throwable) {
            if (throwable == null) {
                CompletableFuture cf = this.getAndSet(STOP);
                AsyncEnumeratorHelper.cancel(this.source);
                if (cf != null && !(cf instanceof TerminalCompletableFuture)) {
                    cf.complete(false);
                }
            } else {
                TerminalCompletableFuture tf = new TerminalCompletableFuture();
                tf.completeExceptionally(throwable);
                CompletableFuture cf = this.getAndSet(tf);
                AsyncEnumeratorHelper.cancel(this.source);
                if (cf != null && !(cf instanceof TerminalCompletableFuture)) {
                    cf.completeExceptionally(throwable);
                }
            }
        }

        @Override
        public void cancel() {
            this.other.cancel();
            AsyncEnumeratorHelper.cancel(this.source);
        }

        static {
            STOP.complete(false);
        }

        static final class TerminalCompletableFuture
        extends CompletableFuture<Boolean> {
            TerminalCompletableFuture() {
            }
        }
    }
}

