/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

final class AsyncTakeUntilPredicate<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Predicate<? super T> stopPredicate;

    AsyncTakeUntilPredicate(AsyncEnumerable<T> source, Predicate<? super T> stopPredicate) {
        this.source = source;
        this.stopPredicate = stopPredicate;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new TakeUntilPredicateEnumerator<T>(this.source.enumerator(), this.stopPredicate);
    }

    static final class TakeUntilPredicateEnumerator<T>
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Predicate<? super T> stopPredicate;
        CompletableFuture<Boolean> completable;
        T current;
        boolean stop;

        TakeUntilPredicateEnumerator(AsyncEnumerator<T> source, Predicate<? super T> stopPredicate) {
            this.source = source;
            this.stopPredicate = stopPredicate;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.current = null;
            if (this.stop) {
                this.source.cancel();
                return AsyncEnumerable.FALSE;
            }
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.source.moveNext().whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.current;
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                T v = this.source.current();
                this.current = v;
                if (this.stopPredicate.test(v)) {
                    this.stop = true;
                }
                this.completable.complete(true);
            } else {
                this.completable.complete(false);
            }
        }
    }
}

