/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

final class AsyncTakeWhile<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Predicate<? super T> predicate;

    AsyncTakeWhile(AsyncEnumerable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new TakeWhileEnumerator<T>(this.source.enumerator(), this.predicate);
    }

    static final class TakeWhileEnumerator<T>
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Predicate<? super T> predicate;
        CompletableFuture<Boolean> completable;
        T current;

        TakeWhileEnumerator(AsyncEnumerator<T> source, Predicate<? super T> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.current = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.source.moveNext().whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.current;
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                T v = this.source.current();
                if (this.predicate.test(v)) {
                    this.current = v;
                    this.completable.complete(true);
                } else {
                    this.source.cancel();
                    this.completable.complete(false);
                }
            } else {
                this.completable.complete(false);
            }
        }
    }
}

