/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

final class AsyncTimeoutTimed<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final long timeout;
    final TimeUnit unit;
    final ScheduledExecutorService executor;
    final AsyncEnumerable<T> fallback;

    AsyncTimeoutTimed(AsyncEnumerable<T> source, long timeout, TimeUnit unit, ScheduledExecutorService executor, AsyncEnumerable<T> fallback) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.executor = executor;
        this.fallback = fallback;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new TimeoutTimedEnumerator<T>(this.source.enumerator(), this.timeout, this.unit, this.executor, this.fallback);
    }

    static final class TimeoutTimedEnumerator<T>
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final long timeout;
        final TimeUnit unit;
        final ScheduledExecutorService executor;
        final AsyncEnumerable<T> fallback;
        final AtomicLong index;
        final AtomicReference<AsyncEnumerator<T>> source;
        volatile CompletableFuture<Boolean> completable;
        Future<?> future;
        T result;

        TimeoutTimedEnumerator(AsyncEnumerator<T> source, long timeout, TimeUnit unit, ScheduledExecutorService executor, AsyncEnumerable<T> fallback) {
            this.source = new AtomicReference<AsyncEnumerator<T>>(source);
            this.timeout = timeout;
            this.unit = unit;
            this.executor = executor;
            this.fallback = fallback;
            this.index = new AtomicLong();
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            AsyncEnumerator<T> en = this.source.getPlain();
            long idx = this.index.get();
            if (idx != Long.MAX_VALUE) {
                this.future = this.executor.schedule(() -> this.timeout(idx), this.timeout, this.unit);
                en.moveNext().whenComplete(this);
            } else {
                en.moveNext().whenComplete(this::acceptFallback);
            }
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            this.future.cancel(false);
            long idx = this.index.get();
            if (idx != Long.MAX_VALUE && this.index.compareAndSet(idx, idx + 1L)) {
                this.acceptFallback(aBoolean, throwable);
            }
        }

        public void acceptFallback(Boolean aBoolean, Throwable throwable) {
            CompletableFuture<Boolean> cf = this.completable;
            if (throwable != null) {
                cf.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.result = this.source.getPlain().current();
                cf.complete(true);
            } else {
                cf.complete(false);
            }
        }

        void timeout(long index) {
            if (this.index.compareAndSet(index, Long.MAX_VALUE)) {
                this.source.getPlain().cancel();
                if (this.fallback != null) {
                    if (AsyncEnumeratorHelper.replace(this.source, this.fallback.enumerator())) {
                        this.source.getPlain().moveNext().whenComplete(this::acceptFallback);
                    }
                } else {
                    this.completable.completeExceptionally(new TimeoutException());
                }
            }
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.source);
        }
    }
}

