/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class AsyncTimer
implements AsyncEnumerable<Long> {
    final long time;
    final TimeUnit unit;
    final ScheduledExecutorService executor;

    AsyncTimer(long time, TimeUnit unit, ScheduledExecutorService executor) {
        this.time = time;
        this.unit = unit;
        this.executor = executor;
    }

    @Override
    public AsyncEnumerator<Long> enumerator() {
        TimerEnumerator en = new TimerEnumerator();
        en.task = this.executor.schedule(en, this.time, this.unit);
        return en;
    }

    static final class TimerEnumerator
    implements AsyncEnumerator<Long>,
    Callable<Void> {
        final CompletableFuture<Boolean> single = new CompletableFuture();
        Long result;
        boolean once;
        Future<?> task;

        TimerEnumerator() {
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.once) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.once = true;
            return this.single;
        }

        @Override
        public Long current() {
            return this.result;
        }

        @Override
        public Void call() throws Exception {
            this.result = 0L;
            this.single.complete(true);
            return null;
        }

        @Override
        public void cancel() {
            this.task.cancel(false);
        }
    }
}

