/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;

final class AsyncToFlowPublisher<T>
implements Flow.Publisher<T> {
    final AsyncEnumerable<T> source;

    AsyncToFlowPublisher(AsyncEnumerable<T> source) {
        this.source = source;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        ToFlowPublisherSubscription<T> parent = new ToFlowPublisherSubscription<T>(subscriber, this.source.enumerator());
        subscriber.onSubscribe(parent);
        parent.moveNext();
    }

    static final class ToFlowPublisherSubscription<T>
    extends AtomicInteger
    implements Flow.Subscription,
    BiConsumer<Boolean, Throwable> {
        final Flow.Subscriber<? super T> actual;
        final AsyncEnumerator<T> enumerator;
        final AtomicInteger mainWip;
        final AtomicLong requested;
        volatile boolean cancelled;
        volatile T item;
        volatile boolean done;
        Throwable error;
        long emitted;

        ToFlowPublisherSubscription(Flow.Subscriber<? super T> actual, AsyncEnumerator<T> enumerator) {
            this.actual = actual;
            this.enumerator = enumerator;
            this.requested = new AtomicLong();
            this.mainWip = new AtomicInteger();
        }

        @Override
        public void request(long n) {
            long u;
            long r;
            if (n <= 0L) {
                n = 1L;
                this.item = null;
                this.error = new IllegalArgumentException("\u00a73.9 violated: positive request required");
                this.done = true;
            }
            do {
                if ((u = (r = this.requested.get()) + n) >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.requested.compareAndSet(r, u));
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.enumerator.cancel();
            if (this.getAndIncrement() == 0) {
                this.item = null;
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.error = throwable;
                this.done = true;
            } else if (aBoolean.booleanValue()) {
                this.item = this.enumerator.current();
            } else {
                this.done = true;
            }
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            long e = this.emitted;
            int missed = 1;
            do {
                boolean d;
                long r = this.requested.get();
                while (e != r) {
                    boolean empty;
                    if (this.cancelled) {
                        this.item = null;
                        return;
                    }
                    d = this.done;
                    T v = this.item;
                    this.item = null;
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex == null) {
                            this.actual.onComplete();
                        } else {
                            this.actual.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    this.actual.onNext(v);
                    ++e;
                    this.moveNext();
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.item = null;
                        return;
                    }
                    d = this.done;
                    if (d && this.item == null) {
                        Throwable ex = this.error;
                        if (ex == null) {
                            this.actual.onComplete();
                        } else {
                            this.actual.onError(ex);
                        }
                        return;
                    }
                }
                this.emitted = e;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void moveNext() {
            if (this.mainWip.getAndIncrement() == 0) {
                do {
                    this.enumerator.moveNext().whenComplete(this);
                } while (this.mainWip.decrementAndGet() != 0);
            }
        }
    }
}

