/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

final class AsyncUsing<T, U>
implements AsyncEnumerable<T> {
    final Supplier<U> resource;
    final Function<? super U, ? extends AsyncEnumerable<T>> handler;
    final Consumer<? super U> releaseResource;

    AsyncUsing(Supplier<U> resource, Function<? super U, ? extends AsyncEnumerable<T>> handler, Consumer<? super U> releaseResource) {
        this.resource = resource;
        this.handler = handler;
        this.releaseResource = releaseResource;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        U res = this.resource.get();
        return new UsingEnumerator<T, U>(res, this.handler.apply(res).enumerator(), this.releaseResource);
    }

    static final class UsingEnumerator<T, U>
    extends AtomicBoolean
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final U resource;
        final AsyncEnumerator<T> source;
        final Consumer<? super U> release;
        T result;
        CompletableFuture<Boolean> completable;

        UsingEnumerator(U resource, AsyncEnumerator<T> source, Consumer<? super U> release) {
            this.resource = resource;
            this.source = source;
            this.release = release;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.source.moveNext().whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.source.cancel();
            this.cleanup();
        }

        void cleanup() {
            if (this.compareAndSet(false, true)) {
                this.release.accept(this.resource);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                this.cleanup();
                return;
            }
            if (aBoolean.booleanValue()) {
                this.result = this.source.current();
                this.completable.complete(true);
            } else {
                this.completable.complete(false);
                this.cleanup();
            }
        }
    }
}

