/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class AsyncZipArray<T, R>
implements AsyncEnumerable<R> {
    final AsyncEnumerable<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    AsyncZipArray(AsyncEnumerable<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    public AsyncEnumerator<R> enumerator() {
        return new ZipArrayEnumerator<T, R>(this.sources, this.zipper);
    }

    static final class ZipArrayEnumerator<T, R>
    extends AtomicInteger
    implements AsyncEnumerator<R> {
        final AsyncEnumerator<? extends T>[] sources;
        final Function<? super Object[], ? extends R> zipper;
        final Object[] results;
        final ZipInnerConsumer[] consumers;
        CompletableFuture<Boolean> completable;
        R result;

        ZipArrayEnumerator(AsyncEnumerable<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
            int n = sources.length;
            this.sources = new AsyncEnumerator[n];
            this.zipper = zipper;
            this.results = new Object[n];
            this.consumers = new ZipInnerConsumer[n];
            for (int i = 0; i < n; ++i) {
                this.sources[i] = sources[i].enumerator();
                this.consumers[i] = new ZipInnerConsumer(i, this);
            }
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            int n = this.results.length;
            this.set(n);
            for (int i = 0; i < n; ++i) {
                this.sources[i].moveNext().whenComplete(this.consumers[i]);
            }
            return cf;
        }

        @Override
        public R current() {
            return this.result;
        }

        void acceptInner(int index, Boolean hasValue, Throwable throwable) {
            CompletableFuture<Boolean> cf = this.completable;
            if (throwable != null) {
                this.completable = null;
                for (int i = 0; i < this.sources.length; ++i) {
                    if (i == index) continue;
                    this.sources[i].cancel();
                }
                cf.completeExceptionally(throwable);
                return;
            }
            if (hasValue.booleanValue()) {
                this.results[index] = this.sources[index].current();
                if (this.decrementAndGet() == 0) {
                    this.result = this.zipper.apply((Object[])this.results.clone());
                    Arrays.fill(this.results, null);
                    cf.complete(true);
                }
            } else {
                this.result = null;
                for (int i = 0; i < this.sources.length; ++i) {
                    if (i == index) continue;
                    this.sources[i].cancel();
                }
                cf.complete(false);
            }
        }

        @Override
        public void cancel() {
            for (AsyncEnumerator<T> asyncEnumerator : this.sources) {
                asyncEnumerator.cancel();
            }
        }

        static final class ZipInnerConsumer
        implements BiConsumer<Boolean, Throwable> {
            final int index;
            final ZipArrayEnumerator<?, ?> parent;

            ZipInnerConsumer(int index, ZipArrayEnumerator<?, ?> parent) {
                this.index = index;
                this.parent = parent;
            }

            @Override
            public void accept(Boolean aBoolean, Throwable throwable) {
                this.parent.acceptInner(this.index, aBoolean, throwable);
            }
        }
    }
}

