/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.expr;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableWhileDoWhile<T>
extends Flowable<T> {
    final Publisher<? extends T> source;
    final BooleanSupplier preCondition;
    final BooleanSupplier postCondition;

    FlowableWhileDoWhile(Publisher<? extends T> source, BooleanSupplier preCondition, BooleanSupplier postCondition) {
        this.source = source;
        this.preCondition = preCondition;
        this.postCondition = postCondition;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        boolean b;
        try {
            b = this.preCondition.getAsBoolean();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        if (b) {
            WhileDoWhileObserver<T> parent = new WhileDoWhileObserver<T>(s, this.postCondition, this.source);
            s.onSubscribe(parent);
            parent.subscribeNext();
        } else {
            EmptySubscription.complete(s);
        }
    }

    static final class WhileDoWhileObserver<T>
    extends SubscriptionArbiter
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5255585317630843019L;
        final Subscriber<? super T> downstream;
        final AtomicInteger wip;
        final BooleanSupplier postCondition;
        final Publisher<? extends T> source;
        volatile boolean active;
        long produced;

        WhileDoWhileObserver(Subscriber<? super T> downstream, BooleanSupplier postCondition, Publisher<? extends T> source) {
            this.downstream = downstream;
            this.wip = new AtomicInteger();
            this.postCondition = postCondition;
            this.source = source;
        }

        public void onSubscribe(Subscription s) {
            super.setSubscription(s);
        }

        public void onNext(T value) {
            ++this.produced;
            this.downstream.onNext(value);
        }

        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        public void onComplete() {
            boolean b;
            try {
                b = this.postCondition.getAsBoolean();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError(ex);
                return;
            }
            if (b) {
                long p = this.produced;
                if (p != 0L) {
                    this.produced(p);
                }
                this.active = false;
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            do {
                if (this.isCancelled()) {
                    return;
                }
                if (this.active) continue;
                this.active = true;
                this.source.subscribe((Subscriber)this);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

