/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableIntervalBackpressure
extends Flowable<Long> {
    final long initialDelay;
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;

    FlowableIntervalBackpressure(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    protected void subscribeActual(Subscriber<? super Long> s) {
        IntervalBackpressureSubscription ibs = new IntervalBackpressureSubscription(s);
        s.onSubscribe((Subscription)ibs);
        ibs.task.replace(this.scheduler.schedulePeriodicallyDirect((Runnable)ibs, this.initialDelay, this.period, this.unit));
    }

    static final class IntervalBackpressureSubscription
    extends AtomicInteger
    implements Subscription,
    Runnable {
        private static final long serialVersionUID = -3871976901922172519L;
        final Subscriber<? super Long> downstream;
        final SequentialDisposable task;
        final AtomicLong requested;
        final AtomicLong available;
        long emitted;

        IntervalBackpressureSubscription(Subscriber<? super Long> downstream) {
            this.downstream = downstream;
            this.task = new SequentialDisposable();
            this.requested = new AtomicLong();
            this.available = new AtomicLong(-1L);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.task.dispose();
        }

        @Override
        public void run() {
            this.available.getAndIncrement();
            this.drain();
        }

        void drain() {
            block4: {
                if (this.getAndIncrement() != 0) break block4;
                int missed = 1;
                SequentialDisposable t = this.task;
                AtomicLong v = this.available;
                long produced = this.emitted;
                Subscriber<? super Long> a = this.downstream;
                do {
                    long r = this.requested.get();
                    while (produced != r) {
                        if (t.isDisposed()) {
                            return;
                        }
                        if (v.get() < produced) break;
                        a.onNext((Object)produced);
                        ++produced;
                    }
                    if (t.isDisposed()) {
                        return;
                    }
                    this.emitted = produced;
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

