/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import hu.akarnokd.rxjava2.operators.BasicEmitter;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiConsumer;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableMapFilter<T, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Publisher<T> source;
    final BiConsumer<? super T, ? super BasicEmitter<R>> consumer;

    FlowableMapFilter(Publisher<T> source, BiConsumer<? super T, ? super BasicEmitter<R>> consumer) {
        this.source = source;
        this.consumer = consumer;
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowableMapFilter<T, R>(upstream, this.consumer);
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapFilterConditionalSubscriber((ConditionalSubscriber)s, this.consumer));
        } else {
            this.source.subscribe(new MapFilterSubscriber<T, R>(s, this.consumer));
        }
    }

    static final class MapFilterConditionalSubscriber<T, R>
    extends BasicFuseableConditionalSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    BasicEmitter<R> {
        final BiConsumer<? super T, ? super BasicEmitter<R>> consumer;
        boolean onNextCalled;
        R outValue;
        Throwable outError;

        MapFilterConditionalSubscriber(ConditionalSubscriber<? super R> downstream, BiConsumer<? super T, ? super BasicEmitter<R>> consumer) {
            super(downstream);
            this.consumer = consumer;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            if (this.sourceMode != 0) {
                return this.downstream.tryOnNext(null);
            }
            try {
                this.consumer.accept(t, (Object)this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.upstream.cancel();
                Throwable e = this.outError;
                this.outError = null;
                if (e != null) {
                    this.downstream.onError((Throwable)new CompositeException(new Throwable[]{e, ex}));
                } else {
                    this.downstream.onError(ex);
                }
                return true;
            }
            boolean b = this.onNextCalled;
            this.onNextCalled = false;
            if (b) {
                R v = this.outValue;
                this.outValue = null;
                b = this.downstream.tryOnNext(v);
            }
            if (this.done) {
                Throwable e = this.outError;
                this.outError = null;
                if (e != null) {
                    this.downstream.onError(e);
                } else {
                    this.downstream.onComplete();
                }
                return true;
            }
            return b;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.done = true;
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void doNext(R t) {
            if (this.onNextCalled) {
                this.doError(new IllegalStateException("doNext already called"));
            } else {
                this.outValue = t;
                this.onNextCalled = true;
            }
        }

        @Override
        public void doError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.upstream.cancel();
                this.done = true;
                this.outError = t;
            }
        }

        @Override
        public void doComplete() {
            if (!this.done) {
                this.upstream.cancel();
                this.done = true;
            }
        }

        public R poll() throws Exception {
            while (true) {
                Object v;
                if ((v = this.qs.poll()) == null) {
                    if (this.done) {
                        Throwable ex = this.outError;
                        this.outError = null;
                        if (ex != null) {
                            MapFilterSubscriber.justThrow(ex);
                        }
                    }
                    return null;
                }
                this.consumer.accept(v, (Object)this);
                boolean b = this.onNextCalled;
                this.onNextCalled = false;
                if (b) {
                    R o = this.outValue;
                    this.outValue = null;
                    return o;
                }
                if (this.done) {
                    Throwable ex = this.outError;
                    this.outError = null;
                    if (ex != null) {
                        MapFilterSubscriber.justThrow(ex);
                    }
                    return null;
                }
                if (this.sourceMode == 1) continue;
                this.upstream.request(1L);
            }
        }

        static <E extends Throwable> void justThrow(Throwable ex) throws E {
            throw ex;
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }
    }

    static final class MapFilterSubscriber<T, R>
    extends BasicFuseableSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    BasicEmitter<R> {
        final BiConsumer<? super T, ? super BasicEmitter<R>> consumer;
        boolean onNextCalled;
        R outValue;
        Throwable outError;

        MapFilterSubscriber(Subscriber<? super R> downstream, BiConsumer<? super T, ? super BasicEmitter<R>> consumer) {
            super(downstream);
            this.consumer = consumer;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return true;
            }
            try {
                this.consumer.accept(t, (Object)this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.upstream.cancel();
                Throwable e = this.outError;
                this.outError = null;
                if (e != null) {
                    this.downstream.onError((Throwable)new CompositeException(new Throwable[]{e, ex}));
                } else {
                    this.downstream.onError(ex);
                }
                return true;
            }
            boolean b = this.onNextCalled;
            this.onNextCalled = false;
            if (b) {
                R v = this.outValue;
                this.outValue = null;
                this.downstream.onNext(v);
            }
            if (this.done) {
                Throwable e = this.outError;
                this.outError = null;
                if (e != null) {
                    this.downstream.onError(e);
                } else {
                    this.downstream.onComplete();
                }
                return true;
            }
            return b;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.done = true;
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void doNext(R t) {
            if (this.onNextCalled) {
                this.doError(new IllegalStateException("doNext already called"));
            } else {
                this.outValue = t;
                this.onNextCalled = true;
            }
        }

        @Override
        public void doError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.upstream.cancel();
                this.done = true;
                this.outError = t;
            }
        }

        @Override
        public void doComplete() {
            if (!this.done) {
                this.upstream.cancel();
                this.done = true;
            }
        }

        public R poll() throws Exception {
            while (true) {
                Object v;
                if ((v = this.qs.poll()) == null) {
                    if (this.done) {
                        Throwable ex = this.outError;
                        this.outError = null;
                        if (ex != null) {
                            MapFilterSubscriber.justThrow(ex);
                        }
                    }
                    return null;
                }
                this.consumer.accept(v, (Object)this);
                boolean b = this.onNextCalled;
                this.onNextCalled = false;
                if (b) {
                    R o = this.outValue;
                    this.outValue = null;
                    return o;
                }
                if (this.done) {
                    Throwable ex = this.outError;
                    this.outError = null;
                    if (ex != null) {
                        MapFilterSubscriber.justThrow(ex);
                    }
                    return null;
                }
                if (this.sourceMode == 1) continue;
                this.upstream.request(1L);
            }
        }

        static <E extends Throwable> void justThrow(Throwable ex) throws E {
            throw ex;
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }
    }
}

