/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.joins;

import hu.akarnokd.rxjava2.functions.Consumer4;
import hu.akarnokd.rxjava2.joins.ActivePlan0;
import hu.akarnokd.rxjava2.joins.JoinObserver1;
import io.reactivex.Notification;
import io.reactivex.functions.Action;

final class ActivePlan4<T1, T2, T3, T4>
extends ActivePlan0 {
    private final Consumer4<T1, T2, T3, T4> onNext;
    private final Action onCompleted;
    private final JoinObserver1<T1> jo1;
    private final JoinObserver1<T2> jo2;
    private final JoinObserver1<T3> jo3;
    private final JoinObserver1<T4> jo4;

    ActivePlan4(JoinObserver1<T1> jo1, JoinObserver1<T2> jo2, JoinObserver1<T3> jo3, JoinObserver1<T4> jo4, Consumer4<T1, T2, T3, T4> onNext, Action onCompleted) {
        this.onNext = onNext;
        this.onCompleted = onCompleted;
        this.jo1 = jo1;
        this.jo2 = jo2;
        this.jo3 = jo3;
        this.jo4 = jo4;
        this.addJoinObserver(jo1);
        this.addJoinObserver(jo2);
        this.addJoinObserver(jo3);
        this.addJoinObserver(jo4);
    }

    @Override
    protected void match() throws Exception {
        if (!(this.jo1.queue().isEmpty() || this.jo2.queue().isEmpty() || this.jo3.queue().isEmpty() || this.jo4.queue().isEmpty())) {
            Notification<T1> n1 = this.jo1.queue().peek();
            Notification<T2> n2 = this.jo2.queue().peek();
            Notification<T3> n3 = this.jo3.queue().peek();
            Notification<T4> n4 = this.jo4.queue().peek();
            if (n1.isOnComplete() || n2.isOnComplete() || n3.isOnComplete() || n4.isOnComplete()) {
                this.onCompleted.run();
            } else {
                this.dequeue();
                this.onNext.accept(n1.getValue(), n2.getValue(), n3.getValue(), n4.getValue());
            }
        }
    }
}

