/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableTimeoutLast<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Publisher<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean fromStart;

    FlowableTimeoutLast(Publisher<T> source, long timeout, TimeUnit unit, Scheduler scheduler, boolean fromStart) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.fromStart = fromStart;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableTimeoutLast<T>(upstream, this.timeout, this.unit, this.scheduler, this.fromStart);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        SerializedSubscriber serial = new SerializedSubscriber(s);
        if (this.fromStart) {
            this.source.subscribe(new TimeoutStartLast(serial, this.timeout, this.unit, this.scheduler));
        } else {
            this.source.subscribe(new TimeoutLast(serial, this.timeout, this.unit, this.scheduler.createWorker()));
        }
    }

    static final class TimeoutStartLast<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = 7744982114753543953L;
        final long timeout;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SequentialDisposable task;
        final AtomicBoolean once;
        final AtomicReference<T> value;
        Subscription upstream;

        TimeoutStartLast(Subscriber<? super T> downstream, long timeout, TimeUnit unit, Scheduler scheduler) {
            super(downstream);
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
            this.task = new SequentialDisposable();
            this.once = new AtomicBoolean();
            this.value = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                this.scheduleTimeout(0L);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value.lazySet(t);
        }

        void scheduleTimeout(long idx) {
            this.task.replace(this.scheduler.scheduleDirect(new Runnable(){

                @Override
                public void run() {
                    if (TimeoutStartLast.this.once.compareAndSet(false, true)) {
                        TimeoutStartLast.this.upstream.cancel();
                        TimeoutStartLast.this.emitLast();
                    }
                }
            }, this.timeout, this.unit));
        }

        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                this.downstream.onError(t);
                this.task.dispose();
                this.value.lazySet(null);
            }
        }

        public void onComplete() {
            if (this.once.compareAndSet(false, true)) {
                this.emitLast();
            }
        }

        void emitLast() {
            T v = this.value.get();
            this.value.lazySet(null);
            if (v != null) {
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
            this.task.dispose();
        }

        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.upstream.cancel();
                this.task.dispose();
                this.value.lazySet(null);
            }
        }
    }

    static final class TimeoutLast<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = 7744982114753543953L;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final SequentialDisposable task;
        final AtomicLong index;
        final AtomicReference<T> value;
        Subscription upstream;

        TimeoutLast(Subscriber<? super T> downstream, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            super(downstream);
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.task = new SequentialDisposable();
            this.index = new AtomicLong();
            this.value = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                this.scheduleTimeout(0L);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            long idx = this.index.incrementAndGet();
            if (idx >= 0L) {
                this.value.lazySet(t);
                Disposable d = (Disposable)this.task.get();
                if (d != null) {
                    d.dispose();
                }
                this.scheduleTimeout(idx);
            }
        }

        void scheduleTimeout(final long idx) {
            this.task.replace(this.worker.schedule(new Runnable(){

                @Override
                public void run() {
                    if (TimeoutLast.this.index.compareAndSet(idx, Long.MIN_VALUE)) {
                        TimeoutLast.this.upstream.cancel();
                        TimeoutLast.this.emitLast();
                    }
                }
            }, this.timeout, this.unit));
        }

        public void onError(Throwable t) {
            this.index.getAndSet(Long.MIN_VALUE);
            this.downstream.onError(t);
            this.worker.dispose();
            this.value.lazySet(null);
        }

        public void onComplete() {
            if (this.index.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.emitLast();
            }
        }

        void emitLast() {
            T v = this.value.get();
            this.value.lazySet(null);
            if (v != null) {
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
            this.worker.dispose();
        }

        public void cancel() {
            if (this.index.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.upstream.cancel();
                this.worker.dispose();
                this.value.lazySet(null);
            }
        }
    }
}

