/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableMapAsync<T, U, R>
extends Observable<R>
implements ObservableTransformer<T, R> {
    final ObservableSource<T> source;
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final int capacityHint;

    ObservableMapAsync(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int capacityHint) {
        this.source = source;
        this.mapper = mapper;
        this.combiner = combiner;
        this.capacityHint = capacityHint;
    }

    public ObservableSource<R> apply(Observable<T> upstream) {
        return new ObservableMapAsync<T, U, R>(upstream, this.mapper, this.combiner, this.capacityHint);
    }

    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new MapAsyncObserver<T, U, R>(observer, this.mapper, this.combiner, this.capacityHint));
    }

    static final class MapAsyncObserver<T, U, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -204261674817426393L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final SpscLinkedArrayQueue<T> queue;
        final AtomicThrowable errors;
        final AtomicReference<Disposable> innerDisposable;
        Disposable upstream;
        volatile boolean done;
        volatile boolean disposed;
        T current;
        volatile int state;
        U inner;
        static final int STATE_FRESH = 0;
        static final int STATE_RUNNING = 1;
        static final int STATE_SUCCESS = 2;
        static final int STATE_EMPTY = 3;

        MapAsyncObserver(Observer<? super R> downstream, Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int capacityHint) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.combiner = combiner;
            this.queue = new SpscLinkedArrayQueue(capacityHint);
            this.errors = new AtomicThrowable();
            this.innerDisposable = new AtomicReference();
        }

        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            DisposableHelper.dispose(this.innerDisposable);
            this.drain();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
                this.upstream = d;
                this.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public void onError(Throwable e) {
            DisposableHelper.dispose(this.innerDisposable);
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            while (true) {
                block10: {
                    int s;
                    block11: {
                        ObservableSource innerSource;
                        boolean empty;
                        Object item;
                        block12: {
                            block9: {
                                if (!this.disposed) break block9;
                                this.current = null;
                                this.inner = null;
                                this.queue.clear();
                                break block10;
                            }
                            if (this.errors.get() != null) {
                                Throwable ex = this.errors.terminate();
                                this.disposed = true;
                                this.downstream.onError(ex);
                                continue;
                            }
                            s = this.state;
                            if (s != 0) break block11;
                            boolean d = this.done;
                            item = this.queue.poll();
                            boolean bl = empty = item == null;
                            if (!d || !empty) break block12;
                            this.downstream.onComplete();
                            break block10;
                        }
                        if (empty) break block10;
                        this.current = item;
                        try {
                            innerSource = (ObservableSource)ObjectHelper.requireNonNull((Object)this.mapper.apply(item), (String)"The mapper returned a null ObservableSource");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.upstream.dispose();
                            this.errors.addThrowable(ex);
                            ex = this.errors.terminate();
                            this.disposed = true;
                            this.downstream.onError(ex);
                            continue;
                        }
                        this.state = 1;
                        innerSource.subscribe((Observer)new InnerObserver());
                        break block10;
                    }
                    if (s == 2) {
                        Object result;
                        T mainItem = this.current;
                        this.current = null;
                        U innerItem = this.inner;
                        this.inner = null;
                        try {
                            result = ObjectHelper.requireNonNull((Object)this.combiner.apply(mainItem, innerItem), (String)"The combiner returned a null value");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.upstream.dispose();
                            this.errors.addThrowable(ex);
                            ex = this.errors.terminate();
                            this.disposed = true;
                            this.downstream.onError(ex);
                            continue;
                        }
                        this.downstream.onNext(result);
                        this.state = 0;
                        continue;
                    }
                    if (s == 3) {
                        this.current = null;
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void innerSuccess(U item) {
            this.inner = item;
            this.state = 2;
            DisposableHelper.replace(this.innerDisposable, null);
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.addThrowable(ex)) {
                this.state = 3;
                DisposableHelper.replace(this.innerDisposable, null);
                this.upstream.dispose();
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        void innerComplete() {
            this.state = 3;
            DisposableHelper.replace(this.innerDisposable, null);
            this.drain();
        }

        final class InnerObserver
        implements Observer<U> {
            boolean once;

            InnerObserver() {
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(MapAsyncObserver.this.innerDisposable, (Disposable)d);
            }

            public void onNext(U t) {
                if (!this.once) {
                    this.once = true;
                    MapAsyncObserver.this.innerDisposable.get().dispose();
                    MapAsyncObserver.this.innerSuccess(t);
                }
            }

            public void onError(Throwable e) {
                if (!this.once) {
                    MapAsyncObserver.this.innerError(e);
                } else {
                    RxJavaPlugins.onError((Throwable)e);
                }
            }

            public void onComplete() {
                if (!this.once) {
                    MapAsyncObserver.this.innerComplete();
                }
            }
        }
    }
}

