/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.consumers;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.OnErrorNotImplementedException;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.observers.LambdaConsumerIntrospection;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractDisposableAutoRelease
extends AtomicReference<Disposable>
implements Disposable,
LambdaConsumerIntrospection {
    private static final long serialVersionUID = 8924480688481408726L;
    final AtomicReference<CompositeDisposable> composite;
    final Consumer<? super Throwable> onError;
    final Action onComplete;

    AbstractDisposableAutoRelease(CompositeDisposable composite, Consumer<? super Throwable> onError, Action onComplete) {
        this.onError = onError;
        this.onComplete = onComplete;
        this.composite = new AtomicReference<CompositeDisposable>(composite);
    }

    public final void onError(Throwable t) {
        if (this.get() != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            if (this.onError != null) {
                try {
                    this.onError.accept((Object)t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
                }
            } else {
                RxJavaPlugins.onError((Throwable)new OnErrorNotImplementedException(t));
            }
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
        this.removeSelf();
    }

    public final void onComplete() {
        if (this.get() != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaPlugins.onError((Throwable)e);
            }
        }
        this.removeSelf();
    }

    public final void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
        this.removeSelf();
    }

    final void removeSelf() {
        CompositeDisposable c = this.composite.getAndSet(null);
        if (c != null) {
            c.delete((Disposable)this);
        }
    }

    public final boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }

    public final void onSubscribe(Disposable d) {
        DisposableHelper.setOnce((AtomicReference)this, (Disposable)d);
    }

    public final boolean hasCustomOnError() {
        return this.onError != null;
    }
}

