/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import hu.akarnokd.rxjava2.operators.BasicMergeSubscription;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Arrays;
import java.util.Comparator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableOrderedMerge<T>
extends Flowable<T> {
    final Publisher<T>[] sources;
    final Iterable<? extends Publisher<T>> sourcesIterable;
    final Comparator<? super T> comparator;
    final boolean delayErrors;
    final int prefetch;

    FlowableOrderedMerge(Publisher<T>[] sources, Iterable<? extends Publisher<T>> sourcesIterable, Comparator<? super T> comparator, boolean delayErrors, int prefetch) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.comparator = comparator;
        this.delayErrors = delayErrors;
        this.prefetch = prefetch;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        int n;
        Publisher<T>[] array = this.sources;
        if (array == null) {
            array = new Publisher[8];
            n = 0;
            try {
                for (Publisher<T> p : this.sourcesIterable) {
                    if (n == array.length) {
                        array = Arrays.copyOf(array, n << 1);
                    }
                    array[n++] = (Publisher)ObjectHelper.requireNonNull(p, (String)"a source is null");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                EmptySubscription.error((Throwable)ex, s);
                return;
            }
        } else {
            n = array.length;
        }
        if (n == 0) {
            EmptySubscription.complete(s);
            return;
        }
        if (n == 1) {
            array[0].subscribe(s);
            return;
        }
        BasicMergeSubscription<T> parent = new BasicMergeSubscription<T>(s, this.comparator, n, this.prefetch, this.delayErrors);
        s.onSubscribe(parent);
        parent.subscribe(array, n);
    }
}

