/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Maybe;
import io.reactivex.MaybeConverter;
import io.reactivex.MaybeObserver;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeFlatMapSignalSingle<T, R>
extends Single<R>
implements MaybeConverter<T, Single<R>> {
    final Maybe<T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> onSuccessHandler;
    final Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler;
    final Callable<? extends SingleSource<? extends R>> onCompleteHandler;

    MaybeFlatMapSignalSingle(Maybe<T> source, Function<? super T, ? extends SingleSource<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler, Callable<? extends SingleSource<? extends R>> onCompleteHandler) {
        this.source = source;
        this.onSuccessHandler = onSuccessHandler;
        this.onErrorHandler = onErrorHandler;
        this.onCompleteHandler = onCompleteHandler;
    }

    public Single<R> apply(Maybe<T> t) {
        return new MaybeFlatMapSignalSingle<T, R>(t, this.onSuccessHandler, this.onErrorHandler, this.onCompleteHandler);
    }

    protected void subscribeActual(SingleObserver<? super R> observer) {
        this.source.subscribe(new FlatMapSignalConsumer<T, R>(observer, this.onSuccessHandler, this.onErrorHandler, this.onCompleteHandler));
    }

    static final class FlatMapSignalConsumer<T, R>
    implements MaybeObserver<T>,
    Disposable {
        final SignalConsumer<R> consumer;
        final Function<? super T, ? extends SingleSource<? extends R>> onSuccessHandler;
        final Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler;
        final Callable<? extends SingleSource<? extends R>> onCompleteHandler;

        FlatMapSignalConsumer(SingleObserver<? super R> downstream, Function<? super T, ? extends SingleSource<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler, Callable<? extends SingleSource<? extends R>> onCompleteHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onSuccessHandler = onSuccessHandler;
            this.onErrorHandler = onErrorHandler;
            this.onCompleteHandler = onCompleteHandler;
        }

        public void dispose() {
            DisposableHelper.dispose(this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onSuccess(T t) {
            SingleSource next;
            try {
                next = (SingleSource)ObjectHelper.requireNonNull((Object)this.onSuccessHandler.apply(t), (String)"The onSuccessHandler returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onComplete() {
            SingleSource next;
            try {
                next = (SingleSource)ObjectHelper.requireNonNull(this.onCompleteHandler.call(), (String)"The onCompleteHandler returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            SingleSource next;
            try {
                next = (SingleSource)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Disposable>
        implements SingleObserver<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final SingleObserver<? super R> downstream;

            SignalConsumer(SingleObserver<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onSuccess(R t) {
                this.downstream.onSuccess(t);
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

