/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.debug;

import hu.akarnokd.rxjava2.debug.CompletableOnAssembly;
import hu.akarnokd.rxjava2.debug.CompletableOnAssemblyCallable;
import hu.akarnokd.rxjava2.debug.CompletableOnAssemblyScalarCallable;
import hu.akarnokd.rxjava2.debug.FlowableOnAssembly;
import hu.akarnokd.rxjava2.debug.FlowableOnAssemblyCallable;
import hu.akarnokd.rxjava2.debug.FlowableOnAssemblyConnectable;
import hu.akarnokd.rxjava2.debug.FlowableOnAssemblyConnectableResettable;
import hu.akarnokd.rxjava2.debug.FlowableOnAssemblyScalarCallable;
import hu.akarnokd.rxjava2.debug.MaybeOnAssembly;
import hu.akarnokd.rxjava2.debug.MaybeOnAssemblyCallable;
import hu.akarnokd.rxjava2.debug.MaybeOnAssemblyScalarCallable;
import hu.akarnokd.rxjava2.debug.ObservableOnAssembly;
import hu.akarnokd.rxjava2.debug.ObservableOnAssemblyCallable;
import hu.akarnokd.rxjava2.debug.ObservableOnAssemblyConnectable;
import hu.akarnokd.rxjava2.debug.ObservableOnAssemblyConnectableResettable;
import hu.akarnokd.rxjava2.debug.ObservableOnAssemblyScalarCallable;
import hu.akarnokd.rxjava2.debug.ParallelFlowableOnAssembly;
import hu.akarnokd.rxjava2.debug.SingleOnAssembly;
import hu.akarnokd.rxjava2.debug.SingleOnAssemblyCallable;
import hu.akarnokd.rxjava2.debug.SingleOnAssemblyScalarCallable;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.ResettableConnectable;
import io.reactivex.internal.fuseable.ScalarCallable;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RxJavaAssemblyTracking {
    static final AtomicBoolean lock = new AtomicBoolean();

    private RxJavaAssemblyTracking() {
        throw new IllegalStateException("No instances!");
    }

    public static void enable() {
        if (lock.compareAndSet(false, true)) {
            RxJavaPlugins.setOnFlowableAssembly((Function)new Function<Flowable, Flowable>(){

                public Flowable apply(Flowable f) throws Exception {
                    if (f instanceof Callable) {
                        if (f instanceof ScalarCallable) {
                            return new FlowableOnAssemblyScalarCallable(f);
                        }
                        return new FlowableOnAssemblyCallable(f);
                    }
                    return new FlowableOnAssembly(f);
                }
            });
            RxJavaPlugins.setOnConnectableFlowableAssembly((Function)new Function<ConnectableFlowable, ConnectableFlowable>(){

                public ConnectableFlowable apply(ConnectableFlowable f) throws Exception {
                    if (f instanceof ResettableConnectable) {
                        return new FlowableOnAssemblyConnectableResettable(f);
                    }
                    return new FlowableOnAssemblyConnectable(f);
                }
            });
            RxJavaPlugins.setOnObservableAssembly((Function)new Function<Observable, Observable>(){

                public Observable apply(Observable f) throws Exception {
                    if (f instanceof Callable) {
                        if (f instanceof ScalarCallable) {
                            return new ObservableOnAssemblyScalarCallable(f);
                        }
                        return new ObservableOnAssemblyCallable(f);
                    }
                    return new ObservableOnAssembly(f);
                }
            });
            RxJavaPlugins.setOnConnectableObservableAssembly((Function)new Function<ConnectableObservable, ConnectableObservable>(){

                public ConnectableObservable apply(ConnectableObservable f) throws Exception {
                    if (f instanceof ResettableConnectable) {
                        return new ObservableOnAssemblyConnectableResettable(f);
                    }
                    return new ObservableOnAssemblyConnectable(f);
                }
            });
            RxJavaPlugins.setOnSingleAssembly((Function)new Function<Single, Single>(){

                public Single apply(Single f) throws Exception {
                    if (f instanceof Callable) {
                        if (f instanceof ScalarCallable) {
                            return new SingleOnAssemblyScalarCallable(f);
                        }
                        return new SingleOnAssemblyCallable(f);
                    }
                    return new SingleOnAssembly(f);
                }
            });
            RxJavaPlugins.setOnCompletableAssembly((Function)new Function<Completable, Completable>(){

                public Completable apply(Completable f) throws Exception {
                    if (f instanceof Callable) {
                        if (f instanceof ScalarCallable) {
                            return new CompletableOnAssemblyScalarCallable((CompletableSource)f);
                        }
                        return new CompletableOnAssemblyCallable((CompletableSource)f);
                    }
                    return new CompletableOnAssembly((CompletableSource)f);
                }
            });
            RxJavaPlugins.setOnMaybeAssembly((Function)new Function<Maybe, Maybe>(){

                public Maybe apply(Maybe f) throws Exception {
                    if (f instanceof Callable) {
                        if (f instanceof ScalarCallable) {
                            return new MaybeOnAssemblyScalarCallable(f);
                        }
                        return new MaybeOnAssemblyCallable(f);
                    }
                    return new MaybeOnAssembly(f);
                }
            });
            RxJavaPlugins.setOnParallelAssembly((Function)new Function<ParallelFlowable, ParallelFlowable>(){

                public ParallelFlowable apply(ParallelFlowable t) throws Exception {
                    return new ParallelFlowableOnAssembly(t);
                }
            });
            lock.set(false);
        }
    }

    public static void disable() {
        if (lock.compareAndSet(false, true)) {
            RxJavaPlugins.setOnCompletableAssembly(null);
            RxJavaPlugins.setOnSingleAssembly(null);
            RxJavaPlugins.setOnMaybeAssembly(null);
            RxJavaPlugins.setOnObservableAssembly(null);
            RxJavaPlugins.setOnFlowableAssembly(null);
            RxJavaPlugins.setOnConnectableObservableAssembly(null);
            RxJavaPlugins.setOnConnectableFlowableAssembly(null);
            RxJavaPlugins.setOnParallelAssembly(null);
            lock.set(false);
        }
    }
}

