/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import hu.akarnokd.rxjava2.operators.PartialCollectEmitter;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.Pow2;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowablePartialCollect<T, I, A, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Flowable<T> source;
    final Consumer<? super PartialCollectEmitter<T, I, A, R>> handler;
    final Consumer<? super T> cleaner;
    final int prefetch;

    FlowablePartialCollect(Flowable<T> source, Consumer<? super PartialCollectEmitter<T, I, A, R>> handler, Consumer<? super T> cleaner, int prefetch) {
        this.source = source;
        this.handler = handler;
        this.cleaner = cleaner;
        this.prefetch = prefetch;
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowablePartialCollect<T, I, A, R>(upstream, this.handler, this.cleaner, this.prefetch);
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new PartialCollectSubscriber(s, this.handler, this.cleaner, this.prefetch));
    }

    static final class PartialCollectSubscriber<T, I, A, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    PartialCollectEmitter<T, I, A, R> {
        private static final long serialVersionUID = -2029240720070492688L;
        final Subscriber<? super R> downstream;
        final Consumer<? super PartialCollectEmitter<T, I, A, R>> handler;
        final Consumer<? super T> cleaner;
        final int prefetch;
        final int limit;
        final AtomicThrowable errors;
        final AtomicReferenceArray<T> queue;
        final AtomicLong producerIndex;
        final AtomicLong requested;
        long consumerIndex;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        I index;
        A accumulator;
        long emitted;
        int consumed;
        boolean handlerDone;

        PartialCollectSubscriber(Subscriber<? super R> downstream, Consumer<? super PartialCollectEmitter<T, I, A, R>> handler, Consumer<? super T> cleaner, int prefetch) {
            this.downstream = downstream;
            this.handler = handler;
            this.cleaner = cleaner;
            this.prefetch = prefetch;
            this.errors = new AtomicThrowable();
            this.queue = new AtomicReferenceArray(Pow2.roundToPowerOfTwo((int)prefetch));
            this.producerIndex = new AtomicLong();
            this.requested = new AtomicLong();
            this.limit = prefetch - (prefetch >> 2);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            AtomicReferenceArray<T> q = this.queue;
            int mask = q.length() - 1;
            long pi = this.producerIndex.get();
            int offset = (int)pi & mask;
            q.lazySet(offset, t);
            this.producerIndex.lazySet(pi + 1L);
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.drain();
        }

        public void request(long n) {
            BackpressureHelper.add((AtomicLong)this.requested, (long)n);
            this.drain();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isComplete() {
            return this.done;
        }

        @Override
        public int size() {
            return (int)(this.producerIndex.get() - this.consumerIndex);
        }

        @Override
        public T getItem(int index) {
            long ci = this.consumerIndex;
            AtomicReferenceArray<T> q = this.queue;
            int mask = q.length() - 1;
            int offset = (int)(ci + (long)index) & mask;
            return q.get(offset);
        }

        @Override
        public void dropItems(int count) {
            long ci;
            int replenish = 0;
            long pi = this.producerIndex.get();
            AtomicReferenceArray<T> q = this.queue;
            int mask = q.length() - 1;
            for (ci = this.consumerIndex; pi != ci && count != replenish; ++ci, ++replenish) {
                int offset = (int)ci & mask;
                this.cleanupItem(q.get(offset));
                q.lazySet(offset, null);
            }
            this.consumerIndex = ci;
            int c = this.consumed + replenish;
            if (c >= this.limit) {
                this.consumed = 0;
                this.upstream.request((long)c);
            } else {
                this.consumed = c;
            }
        }

        @Override
        public I getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(I newIndex) {
            this.index = newIndex;
        }

        @Override
        public A getAccumulator() {
            return this.accumulator;
        }

        @Override
        public void setAccumulator(A newAccumulator) {
            this.accumulator = newAccumulator;
        }

        @Override
        public void next(R item) {
            long e = this.emitted;
            if (e == this.requested.get()) {
                this.handlerDone = true;
                throw new MissingBackpressureException();
            }
            this.emitted = e + 1L;
            this.downstream.onNext(item);
        }

        @Override
        public void complete() {
            this.handlerDone = true;
        }

        @Override
        public void cleanupItem(T item) {
            try {
                this.cleaner.accept(item);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        @Override
        public long demand() {
            return this.requested.get() - this.emitted;
        }

        void cleanup() {
            long ci;
            long pi = this.producerIndex.get();
            AtomicReferenceArray<T> q = this.queue;
            int mask = q.length() - 1;
            for (ci = this.consumerIndex; pi != ci; ++ci) {
                int offset = (int)ci & mask;
                this.cleanupItem(q.get(offset));
                q.lazySet(offset, null);
            }
            this.consumerIndex = ci;
            this.index = null;
            this.accumulator = null;
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            block2: do {
                if (this.cancelled) {
                    this.cleanup();
                    continue;
                }
                while (true) {
                    Throwable ex;
                    boolean d;
                    if ((d = this.done) && this.errors.get() != null) {
                        ex = this.errors.terminate();
                        this.downstream.onError(ex);
                        this.cleanup();
                        this.cancelled = true;
                        continue block2;
                    }
                    if (this.handlerDone) {
                        ex = this.errors.terminate();
                        if (ex == null) {
                            this.downstream.onComplete();
                        } else {
                            this.downstream.onError(ex);
                        }
                        this.cleanup();
                        this.cancelled = true;
                        continue block2;
                    }
                    long e = this.emitted;
                    long ci = this.consumerIndex;
                    try {
                        this.handler.accept((Object)this);
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal((Throwable)ex2);
                        this.upstream.cancel();
                        this.errors.addThrowable(ex2);
                        this.handlerDone = true;
                        continue;
                    }
                    if (!this.handlerDone && e == this.emitted && ci == this.consumerIndex) break;
                }
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

