/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableSwitchOnFirst<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final Predicate<? super T> predicate;
    final Function<? super T, ? extends Publisher<? extends T>> selector;

    FlowableSwitchOnFirst(Flowable<T> source, Predicate<? super T> predicate, Function<? super T, ? extends Publisher<? extends T>> selector) {
        this.source = source;
        this.predicate = predicate;
        this.selector = selector;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new SwitchOnFirstSubscriber<T>(s, this.predicate, this.selector));
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableSwitchOnFirst<T>(upstream, this.predicate, this.selector);
    }

    static final class SwitchOnFirstSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3008387388867141204L;
        final Subscriber<? super T> downstream;
        final Predicate<? super T> predicate;
        final Function<? super T, ? extends Publisher<? extends T>> selector;
        final SwitchOnSecondarySubscriber<T> secondary;
        Subscription upstream;
        boolean isMainSequence;
        boolean once;

        SwitchOnFirstSubscriber(Subscriber<? super T> downstream, Predicate<? super T> predicate, Function<? super T, ? extends Publisher<? extends T>> selector) {
            this.downstream = downstream;
            this.predicate = predicate;
            this.selector = selector;
            this.secondary = new SwitchOnSecondarySubscriber<T>(downstream);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.once) {
                this.once = true;
                Publisher resume = null;
                try {
                    if (this.predicate.test(t)) {
                        resume = (Publisher)ObjectHelper.requireNonNull((Object)this.selector.apply(t), (String)"The selector returned a null Publisher");
                    }
                }
                catch (Throwable ex) {
                    this.upstream.cancel();
                    this.downstream.onError(ex);
                    return;
                }
                if (resume != null) {
                    this.upstream.cancel();
                    this.upstream = SubscriptionHelper.CANCELLED;
                    resume.subscribe(this.secondary);
                } else {
                    this.isMainSequence = true;
                }
            }
            if (this.isMainSequence) {
                this.downstream.onNext(t);
            }
        }

        public void onError(Throwable t) {
            if (!this.once || this.isMainSequence) {
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (!this.once || this.isMainSequence) {
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            if (this.compareAndSet(false, true)) {
                this.upstream.request(1L);
                if (--n == 0L) {
                    return;
                }
            }
            if (this.isMainSequence) {
                this.upstream.request(n);
            } else {
                SwitchOnSecondarySubscriber<T> secondary = this.secondary;
                if (secondary.upstream.get() == null) {
                    this.upstream.request(n);
                }
                SubscriptionHelper.deferredRequest(secondary.upstream, secondary, (long)n);
            }
        }

        public void cancel() {
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.secondary.upstream);
        }

        static final class SwitchOnSecondarySubscriber<T>
        extends AtomicLong
        implements FlowableSubscriber<T> {
            private static final long serialVersionUID = 6866823891735850338L;
            final Subscriber<? super T> downstream;
            final AtomicReference<Subscription> upstream;

            SwitchOnSecondarySubscriber(Subscriber<? super T> downstream) {
                this.downstream = downstream;
                this.upstream = new AtomicReference();
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.deferredSetOnce(this.upstream, (AtomicLong)this, (Subscription)s);
            }

            public void onNext(T t) {
                this.downstream.onNext(t);
            }

            public void onError(Throwable t) {
                this.downstream.onError(t);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }
        }
    }
}

