/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableErrorJump<T, R>
extends Observable<R>
implements ObservableTransformer<T, R> {
    final Observable<T> source;
    final ObservableTransformer<T, R> transformer;

    ObservableErrorJump(Observable<T> source, ObservableTransformer<T, R> transformer) {
        this.source = source;
        this.transformer = transformer;
    }

    public ObservableSource<R> apply(Observable<T> upstream) {
        return new ObservableErrorJump<T, R>(upstream, this.transformer);
    }

    protected void subscribeActual(Observer<? super R> observer) {
        ObservableSource downstream;
        ErrorJumpFront<T, ? super R> front = new ErrorJumpFront<T, R>(this.source, observer);
        try {
            downstream = (ObservableSource)ObjectHelper.requireNonNull((Object)this.transformer.apply(front), (String)"The transformer returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptyDisposable.error((Throwable)ex, observer);
            return;
        }
        downstream.subscribe((Observer)front.end);
    }

    static final class ErrorJumpFront<T, R>
    extends Observable<T>
    implements Observer<T>,
    Disposable {
        final Observable<T> source;
        final AtomicReference<Observer<? super T>> middle;
        final EndSubscriber end;
        Disposable upstream;

        ErrorJumpFront(Observable<T> source, Observer<? super R> downstream) {
            this.source = source;
            this.middle = new AtomicReference();
            this.end = new EndSubscriber(downstream);
        }

        protected void subscribeActual(Observer<? super T> observer) {
            if (this.middle.compareAndSet(null, observer)) {
                this.source.subscribe((Observer)this);
            } else {
                EmptyDisposable.error((Throwable)new IllegalStateException("Only one Subscriber allowed"), observer);
            }
        }

        public void onSubscribe(Disposable d) {
            this.upstream = d;
            this.middle.get().onSubscribe((Disposable)this);
        }

        public void onNext(T t) {
            this.middle.get().onNext(t);
        }

        public void onError(Throwable t) {
            this.end.set(t);
            this.middle.get().onComplete();
        }

        public void onComplete() {
            this.middle.get().onComplete();
        }

        public void dispose() {
            this.upstream.dispose();
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        final class EndSubscriber
        extends AtomicReference<Throwable>
        implements Observer<R>,
        Disposable {
            private static final long serialVersionUID = -5718512540714037078L;
            final Observer<? super R> downstream;
            Disposable upstream;

            EndSubscriber(Observer<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                this.upstream = d;
                this.downstream.onSubscribe((Disposable)this);
            }

            public void onNext(R t) {
                this.downstream.onNext(t);
            }

            public void onError(Throwable t) {
                Throwable ex = (Throwable)this.get();
                if (ex != null) {
                    t = new CompositeException(new Throwable[]{ex, t});
                }
                this.downstream.onError(t);
            }

            public void onComplete() {
                Throwable ex = (Throwable)this.get();
                if (ex != null) {
                    this.downstream.onError(ex);
                } else {
                    this.downstream.onComplete();
                }
            }

            public void dispose() {
                this.upstream.dispose();
            }

            public boolean isDisposed() {
                return this.upstream.isDisposed();
            }
        }
    }
}

