/*
 * Copyright 2017-2018 David Karnok
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package hu.akarnokd.rxjava2.swing;

import java.awt.Container;
import java.awt.event.*;

import io.reactivex.*;

final class ContainerEventObservable extends Observable<ContainerEvent> {

    final Container widget;

    ContainerEventObservable(Container widget) {
        this.widget = widget;
    }

    @Override
    protected void subscribeActual(Observer<? super ContainerEvent> observer) {
        Container w = widget;

        ContainerEventConsumer aec = new ContainerEventConsumer(observer, w);
        observer.onSubscribe(aec);

        w.addContainerListener(aec);
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class ContainerEventConsumer extends AbstractEventConsumer<ContainerEvent, Container>
    implements ContainerListener {

        private static final long serialVersionUID = -3605206827474016488L;

        ContainerEventConsumer(Observer<? super ContainerEvent> actual, Container widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(Container w) {
            w.removeContainerListener(this);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            actual.onNext(e);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            actual.onNext(e);
        }
    }
}
