/*
 * Decompiled with CFR 0.152.
 */
package org.jasmine.cli;

import java.util.ArrayList;
import java.util.List;
import org.jasmine.SpecScanner;
import org.jasmine.cli.CompileMode;
import org.jasmine.cli.Formatter;
import org.jasmine.cli.OutputFormat;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.Setter;

public class Arguments {
    @Option(name="--pattern")
    private String pattern;
    @Option(name="--compile-mode", handler=CompileModeEnumOptionHandler.class)
    private CompileMode compileMode = CompileMode.JIT;
    @Option(name="--format", handler=OutputFormatEnumOptionHandler.class)
    private OutputFormat format = OutputFormat.PROGRESS;
    @Argument
    private List<String> arguments = new ArrayList<String>();

    public static Arguments parse(String ... args) {
        Arguments arguments = new Arguments();
        CmdLineParser parser = new CmdLineParser((Object)arguments);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            throw new RuntimeException(e);
        }
        return arguments;
    }

    public Iterable<String> specs() {
        if (this.pattern != null) {
            return new SpecScanner().findSpecs(this.pattern);
        }
        return this.arguments;
    }

    public CompileMode compileMode() {
        return this.compileMode;
    }

    public Formatter formatter() {
        return this.format.formatter();
    }

    public static class OutputFormatEnumOptionHandler
    extends EnumOptionHandler<OutputFormat> {
        public OutputFormatEnumOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super OutputFormat> setter) {
            super(parser, option, setter, OutputFormat.class);
        }
    }

    public static class CompileModeEnumOptionHandler
    extends EnumOptionHandler<CompileMode> {
        public CompileModeEnumOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super CompileMode> setter) {
            super(parser, option, setter, CompileMode.class);
        }
    }
}

