/*
 * Decompiled with CFR 0.152.
 */
package org.jasmine.cli;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jasmine.Failure;
import org.jasmine.Identifier;
import org.jasmine.Notifier;
import org.jasmine.cli.Formatter;
import org.jasmine.cli.JVM;
import org.jasmine.cli.Summary;

public class CliNotifier
implements Notifier {
    private final PrintStream out;
    private final JVM jvm;
    private final Formatter formatter;
    private final Multimap<Identifier, Failure> failures = HashMultimap.create();
    private final Map<Identifier, String> descriptions = new HashMap<Identifier, String>();

    public CliNotifier(PrintStream out, JVM jvm, Formatter formatter) {
        this.out = out;
        this.jvm = jvm;
        this.formatter = formatter;
    }

    public void started() {
    }

    public void pass(Identifier identifier, String description) {
        this.descriptions.put(identifier, description);
        this.out.print(this.formatter.formatSingularPass(identifier, description));
    }

    public void fail(Identifier identifier, String description, Set<Failure> failures) {
        this.descriptions.put(identifier, description);
        this.failures.putAll((Object)identifier, failures);
        this.out.print(this.formatter.formatSingularFail(identifier, description, failures));
    }

    public void finished() {
        this.out.print(this.formatter.formatSummary(new Summary(this.descriptions, this.failures)));
        if (!this.failures.isEmpty()) {
            this.jvm.die();
        }
    }
}

