/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.protocol.http.HttpFrame;
import fr.bmartel.protocol.http.states.HttpStates;
import fr.bmartel.speedtest.ISpeedTestListener;
import fr.bmartel.speedtest.RandomGen;
import fr.bmartel.speedtest.SpeedTestError;
import fr.bmartel.speedtest.SpeedTestMode;
import fr.bmartel.speedtest.SpeedTestReport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;

public class SpeedTestSocket {
    private static final int READ_BUFFER_SIZE = 65535;
    private static final int DEFAULT_UPLOAD_SIZE_CHUNK = 65535;
    private String hostname = "";
    private int port = 0;
    private Socket socket = null;
    private Thread readingThread = null;
    private volatile boolean isReading = false;
    private List<ISpeedTestListener> speedTestListenerList = new ArrayList<ISpeedTestListener>();
    private int uploadFileSize = 0;
    private long timeStart = 0L;
    private long timeEnd = 0L;
    private SpeedTestMode speedTestMode = SpeedTestMode.NONE;
    private int uploadChunkSize = 65535;
    private int uploadTemporaryFileSize = 0;
    private int downloadTemporaryPacketSize = 0;
    private int downloadPacketSize = 0;

    public void addSpeedTestListener(ISpeedTestListener listener) {
        this.speedTestListenerList.add(listener);
    }

    public void removeSpeedTestListener(ISpeedTestListener listener) {
        this.speedTestListenerList.remove(listener);
    }

    public void connectAndExecuteTask(TimerTask task, final boolean isDownload) {
        block10: {
            boolean socketError = false;
            if (this.socket != null) {
                this.closeSocket();
            }
            try {
                this.socket = new Socket();
                this.socket.setReuseAddress(true);
                this.socket.setKeepAlive(true);
                this.socket.connect(new InetSocketAddress(this.hostname, this.port));
                if (this.readingThread != null) {
                    this.isReading = false;
                    this.readingThread.join();
                }
                this.isReading = true;
                this.readingThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean isSocketError = false;
                        if (isDownload) {
                            byte[] buffer = new byte[65535];
                            int read = 0;
                            SpeedTestSocket.this.downloadTemporaryPacketSize = 0;
                            try {
                                int i;
                                HttpStates headerError;
                                HttpFrame httpFrame = new HttpFrame();
                                SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                                HttpStates errorCode = httpFrame.decodeFrame(SpeedTestSocket.this.socket.getInputStream());
                                if (errorCode != HttpStates.HTTP_FRAME_OK) {
                                    System.err.println("Error while parsing http frame");
                                    for (int i2 = 0; i2 < SpeedTestSocket.this.speedTestListenerList.size(); ++i2) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i2)).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE);
                                    }
                                }
                                if ((headerError = httpFrame.parseHeader(SpeedTestSocket.this.socket.getInputStream())) != HttpStates.HTTP_FRAME_OK) {
                                    System.err.println("Error while parsing http headers");
                                    for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE);
                                    }
                                }
                                if (httpFrame.getContentLength() < 0) {
                                    System.err.println("Error content length is inconsistent");
                                    for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE);
                                    }
                                }
                                SpeedTestSocket.this.downloadPacketSize = httpFrame.getContentLength();
                                while ((read = SpeedTestSocket.this.socket.getInputStream().read(buffer)) != -1) {
                                    SpeedTestSocket.this.downloadTemporaryPacketSize += read;
                                    for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        SpeedTestReport report = SpeedTestSocket.this.getLiveDownloadReport();
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadProgress(report.getProgressPercent(), SpeedTestSocket.this.getLiveDownloadReport());
                                    }
                                    if (SpeedTestSocket.this.downloadTemporaryPacketSize != SpeedTestSocket.this.downloadPacketSize) continue;
                                }
                                SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                                float transferRate_bps = (float)(SpeedTestSocket.this.downloadPacketSize * 8) / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                                float transferRate_Bps = (float)SpeedTestSocket.this.downloadPacketSize / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                                for (int i3 = 0; i3 < SpeedTestSocket.this.speedTestListenerList.size(); ++i3) {
                                    ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i3)).onDownloadPacketsReceived(SpeedTestSocket.this.downloadPacketSize, transferRate_bps, transferRate_Bps);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                isSocketError = true;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                isSocketError = true;
                            }
                            if (isSocketError) {
                                for (int i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                    ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadError(SpeedTestError.SOCKET_ERROR);
                                }
                            }
                            SpeedTestSocket.this.closeSocket();
                        } else {
                            while (SpeedTestSocket.this.isReading) {
                                try {
                                    HttpFrame frame = new HttpFrame();
                                    HttpStates httpStates = frame.parseHttp(SpeedTestSocket.this.socket.getInputStream());
                                    if (httpStates == HttpStates.HTTP_FRAME_OK) {
                                        if (frame.getStatusCode() == 200 && frame.getReasonPhrase().toLowerCase().equals("ok")) {
                                            SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                                            float transferRate_bps = (float)(SpeedTestSocket.this.uploadFileSize * 8) / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                                            float transferRate_Bps = (float)SpeedTestSocket.this.uploadFileSize / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                                            for (int i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                                ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onUploadPacketsReceived(SpeedTestSocket.this.uploadFileSize, transferRate_bps, transferRate_Bps);
                                            }
                                        }
                                        SpeedTestSocket.this.speedTestMode = SpeedTestMode.NONE;
                                        return;
                                    }
                                    if (httpStates == HttpStates.HTTP_READING_ERROR) {
                                        SpeedTestSocket.this.isReading = false;
                                        SpeedTestSocket.this.closeSocket();
                                    }
                                    for (int i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onUploadError(SpeedTestError.SOCKET_ERROR);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        SpeedTestSocket.this.speedTestMode = SpeedTestMode.NONE;
                    }
                });
                this.readingThread.start();
                if (task != null) {
                    task.run();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                socketError = true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                socketError = true;
            }
            if (!socketError) break block10;
            if (isDownload) {
                for (int i = 0; i < this.speedTestListenerList.size(); ++i) {
                    this.speedTestListenerList.get(i).onDownloadError(SpeedTestError.CONNECTION_ERROR);
                }
            } else {
                for (int i = 0; i < this.speedTestListenerList.size(); ++i) {
                    this.speedTestListenerList.get(i).onUploadError(SpeedTestError.CONNECTION_ERROR);
                }
            }
        }
    }

    public void startDownload(String hostname, int port, String uri) {
        this.hostname = hostname;
        this.port = port;
        String downloadRequest = "GET " + uri + " HTTP/1.1\r\n" + "Host: " + hostname + "\r\n\r\n";
        this.writeDownload(downloadRequest.getBytes());
    }

    public void writeDownload(final byte[] data) {
        this.speedTestMode = SpeedTestMode.DOWNLOAD;
        this.connectAndExecuteTask(new TimerTask(){

            @Override
            public void run() {
                if (SpeedTestSocket.this.socket != null && !SpeedTestSocket.this.socket.isClosed()) {
                    try {
                        if (SpeedTestSocket.this.socket.getOutputStream() != null) {
                            SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                            SpeedTestSocket.this.socket.getOutputStream().write(data);
                            SpeedTestSocket.this.socket.getOutputStream().flush();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, true);
    }

    public void startUpload(String hostname, int port, String uri, int fileSizeOctet) {
        this.hostname = hostname;
        this.port = port;
        this.uploadFileSize = fileSizeOctet;
        this.timeEnd = 0L;
        RandomGen random = new RandomGen(fileSizeOctet);
        byte[] fileContent = random.nextArray();
        String uploadRequest = "POST " + uri + " HTTP/1.1\r\n" + "Host: " + hostname + "\r\nAccept: */*\r\nContent-Length: " + fileSizeOctet + "\r\n\r\n";
        this.writeUpload(uploadRequest.getBytes(), fileContent);
    }

    public void writeUpload(final byte[] head, final byte[] body) {
        this.speedTestMode = SpeedTestMode.UPLOAD;
        this.connectAndExecuteTask(new TimerTask(){

            @Override
            public void run() {
                if (SpeedTestSocket.this.socket != null && !SpeedTestSocket.this.socket.isClosed()) {
                    try {
                        SpeedTestSocket.this.uploadTemporaryFileSize = 0;
                        int step = body.length / SpeedTestSocket.this.uploadChunkSize;
                        int remain = body.length % SpeedTestSocket.this.uploadChunkSize;
                        if (SpeedTestSocket.this.socket.getOutputStream() != null) {
                            SpeedTestSocket.this.socket.getOutputStream().write(head);
                            SpeedTestSocket.this.socket.getOutputStream().flush();
                            SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                            for (int i = 0; i < step; ++i) {
                                SpeedTestSocket.this.socket.getOutputStream().write(Arrays.copyOfRange(body, SpeedTestSocket.this.uploadTemporaryFileSize, SpeedTestSocket.this.uploadTemporaryFileSize + SpeedTestSocket.this.uploadChunkSize));
                                SpeedTestSocket.this.socket.getOutputStream().flush();
                                for (int j = 0; j < SpeedTestSocket.this.speedTestListenerList.size(); ++j) {
                                    SpeedTestReport report = SpeedTestSocket.this.getLiveUploadReport();
                                    ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(j)).onUploadProgress(report.getProgressPercent(), report);
                                }
                                SpeedTestSocket.this.uploadTemporaryFileSize += SpeedTestSocket.this.uploadChunkSize;
                            }
                            if (remain != 0) {
                                SpeedTestSocket.this.socket.getOutputStream().write(Arrays.copyOfRange(body, SpeedTestSocket.this.uploadTemporaryFileSize, SpeedTestSocket.this.uploadTemporaryFileSize + remain));
                                SpeedTestSocket.this.socket.getOutputStream().flush();
                            }
                            for (int j = 0; j < SpeedTestSocket.this.speedTestListenerList.size(); ++j) {
                                ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(j)).onUploadProgress(100.0f, SpeedTestSocket.this.getLiveUploadReport());
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, false);
    }

    public SpeedTestReport getLiveDownloadReport() {
        return this.getReport(SpeedTestMode.DOWNLOAD);
    }

    public SpeedTestReport getLiveUploadReport() {
        return this.getReport(SpeedTestMode.UPLOAD);
    }

    private SpeedTestReport getReport(SpeedTestMode mode) {
        int temporaryPacketSize = 0;
        int totalPacketSize = 0;
        switch (mode) {
            case DOWNLOAD: {
                temporaryPacketSize = this.downloadTemporaryPacketSize;
                totalPacketSize = this.downloadPacketSize;
                break;
            }
            case UPLOAD: {
                temporaryPacketSize = this.uploadTemporaryFileSize;
                totalPacketSize = this.uploadFileSize;
            }
        }
        long currentTime = this.timeEnd == 0L ? System.currentTimeMillis() : this.timeEnd;
        float transferRate_bps = (float)(temporaryPacketSize * 8) / ((float)(currentTime - this.timeStart) / 1000.0f);
        float transferRate_Bps = (float)temporaryPacketSize / ((float)(currentTime - this.timeStart) / 1000.0f);
        float percent = 0.0f;
        if (totalPacketSize != 0) {
            percent = (float)temporaryPacketSize * 100.0f / (float)totalPacketSize;
        }
        return new SpeedTestReport(mode, percent, this.timeStart, currentTime, temporaryPacketSize, totalPacketSize, transferRate_Bps, transferRate_bps);
    }

    public void closeSocket() {
        if (this.socket != null) {
            try {
                this.socket.getOutputStream().close();
                this.socket.getInputStream().close();
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    public void closeSocketJoinRead() {
        if (this.readingThread != null) {
            this.isReading = false;
            try {
                this.readingThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.closeSocket();
    }

    public SpeedTestMode getSpeedTestMode() {
        return this.speedTestMode;
    }

    public int getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    public void setUploadChunkSize(int uploadChunkSize) {
        this.uploadChunkSize = uploadChunkSize;
    }
}

