/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.protocol.http.HttpFrame;
import fr.bmartel.protocol.http.states.HttpStates;
import fr.bmartel.speedtest.IRepeatListener;
import fr.bmartel.speedtest.ISpeedTestListener;
import fr.bmartel.speedtest.RandomGen;
import fr.bmartel.speedtest.SpeedTestError;
import fr.bmartel.speedtest.SpeedTestMode;
import fr.bmartel.speedtest.SpeedTestReport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class SpeedTestSocket {
    private static final int READ_BUFFER_SIZE = 65535;
    private static final int DEFAULT_UPLOAD_SIZE_CHUNK = 65535;
    private String hostname = "";
    private int port = 0;
    private Socket socket = null;
    private volatile boolean isReading = false;
    private List<ISpeedTestListener> speedTestListenerList = new ArrayList<ISpeedTestListener>();
    private long uploadFileSize = 0L;
    private long timeStart = 0L;
    private long timeEnd = 0L;
    private SpeedTestMode speedTestMode = SpeedTestMode.NONE;
    private int uploadChunkSize = 65535;
    private int uploadTemporaryFileSize = 0;
    private int downloadTemporaryPacketSize = 0;
    private long downloadPacketSize = 0L;
    private int socketTimeout = 0;
    private boolean isForceCloseSocket = false;
    private boolean isRepeatDownload = false;
    private long startDateRepeat = 0L;
    private int repeatWindows = 0;
    private int repeatRequestNum = 0;
    private long repeatPacketSize = 0L;
    private long repeatTemporaryPacketSize = 0L;
    private float repeatTransferRateBps = 0.0f;
    private boolean isFirstDownloadRepeat = false;
    private boolean repeatFinished = false;
    private static final int THREAD_POOL_SIZE = 1;
    private ScheduledExecutorService executorService = null;
    private static final String FORCE_CLOSE_CAUSE_MESSAGE = " caused by socket force close";

    public SpeedTestSocket() {
        this.initThreadPool();
    }

    public void addSpeedTestListener(ISpeedTestListener listener) {
        this.speedTestListenerList.add(listener);
    }

    public void removeSpeedTestListener(ISpeedTestListener listener) {
        this.speedTestListenerList.remove(listener);
    }

    private void initThreadPool() {
        this.executorService = Executors.newScheduledThreadPool(1);
    }

    public void connectAndExecuteTask(TimerTask task, final boolean isDownload) {
        if (this.socket != null) {
            this.closeSocket();
        }
        try {
            this.socket = new Socket();
            if (this.socketTimeout != 0 && isDownload) {
                this.socket.setSoTimeout(this.socketTimeout);
            }
            this.socket.setReuseAddress(true);
            this.socket.setKeepAlive(true);
            this.socket.connect(new InetSocketAddress(this.hostname, this.port));
            this.isReading = true;
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (isDownload) {
                        byte[] buffer = new byte[65535];
                        int read = 0;
                        SpeedTestSocket.this.downloadTemporaryPacketSize = 0;
                        try {
                            int i;
                            HttpStates headerError;
                            HttpFrame httpFrame = new HttpFrame();
                            SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                            if (SpeedTestSocket.this.isFirstDownloadRepeat && SpeedTestSocket.this.isRepeatDownload) {
                                SpeedTestSocket.this.isFirstDownloadRepeat = false;
                                SpeedTestSocket.this.startDateRepeat = SpeedTestSocket.this.timeStart;
                            }
                            SpeedTestSocket.this.timeEnd = 0L;
                            HttpStates errorCode = httpFrame.decodeFrame(SpeedTestSocket.this.socket.getInputStream());
                            if (errorCode != HttpStates.HTTP_FRAME_OK) {
                                int i2;
                                System.err.println("Error while parsing http frame");
                                if (!SpeedTestSocket.this.isForceCloseSocket) {
                                    for (i2 = 0; i2 < SpeedTestSocket.this.speedTestListenerList.size(); ++i2) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i2)).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error while parsing http frame");
                                    }
                                } else {
                                    for (i2 = 0; i2 < SpeedTestSocket.this.speedTestListenerList.size(); ++i2) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i2)).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, "Error while parsing http frame caused by socket force close");
                                    }
                                }
                            }
                            if ((headerError = httpFrame.parseHeader(SpeedTestSocket.this.socket.getInputStream())) != HttpStates.HTTP_FRAME_OK) {
                                System.err.println("Error while parsing http headers");
                                if (!SpeedTestSocket.this.isForceCloseSocket) {
                                    for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error while parsing http headers");
                                    }
                                } else {
                                    for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, "Error while parsing http headers caused by socket force close");
                                    }
                                }
                            }
                            if (httpFrame.getContentLength() < 0) {
                                System.err.println("Error content length is inconsistent");
                                if (!SpeedTestSocket.this.isForceCloseSocket) {
                                    for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error content length is inconsistent");
                                    }
                                } else {
                                    for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, "Error content length is inconsistent caused by socket force close");
                                    }
                                }
                            }
                            SpeedTestSocket.this.downloadPacketSize = httpFrame.getContentLength();
                            if (SpeedTestSocket.this.isRepeatDownload) {
                                SpeedTestSocket.this.repeatPacketSize += SpeedTestSocket.this.downloadPacketSize;
                            }
                            while ((read = SpeedTestSocket.this.socket.getInputStream().read(buffer)) != -1) {
                                SpeedTestSocket.this.downloadTemporaryPacketSize += read;
                                if (SpeedTestSocket.this.isRepeatDownload) {
                                    SpeedTestSocket.this.repeatTemporaryPacketSize += read;
                                }
                                for (i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                    SpeedTestReport report = SpeedTestSocket.this.getLiveDownloadReport();
                                    ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onDownloadProgress(report.getProgressPercent(), SpeedTestSocket.this.getLiveDownloadReport());
                                }
                                if ((long)SpeedTestSocket.this.downloadTemporaryPacketSize != SpeedTestSocket.this.downloadPacketSize) continue;
                            }
                            SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                            float transferRate_bps = (float)(SpeedTestSocket.this.downloadPacketSize * 8L) / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                            float transferRate_Bps = (float)SpeedTestSocket.this.downloadPacketSize / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                            SpeedTestSocket.this.closeSocket();
                            for (int i3 = 0; i3 < SpeedTestSocket.this.speedTestListenerList.size(); ++i3) {
                                ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i3)).onDownloadPacketsReceived(SpeedTestSocket.this.downloadPacketSize, transferRate_bps, transferRate_Bps);
                            }
                            if (!SpeedTestSocket.this.isRepeatDownload) {
                                SpeedTestSocket.this.executorService.shutdown();
                            }
                        }
                        catch (IOException e) {
                            SpeedTestSocket.this.dispatchError(isDownload, e.getMessage());
                            SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                            SpeedTestSocket.this.closeSocket();
                            SpeedTestSocket.this.executorService.shutdown();
                        }
                        catch (InterruptedException e) {
                            SpeedTestSocket.this.dispatchError(isDownload, e.getMessage());
                            SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                            SpeedTestSocket.this.closeSocket();
                            SpeedTestSocket.this.executorService.shutdown();
                        }
                    } else {
                        while (SpeedTestSocket.this.isReading) {
                            try {
                                HttpFrame frame = new HttpFrame();
                                HttpStates httpStates = frame.parseHttp(SpeedTestSocket.this.socket.getInputStream());
                                if (httpStates == HttpStates.HTTP_FRAME_OK) {
                                    if (frame.getStatusCode() == 200 && frame.getReasonPhrase().toLowerCase().equals("ok")) {
                                        SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                                        float transferRate_bps = (float)(SpeedTestSocket.this.uploadFileSize * 8L) / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                                        float transferRate_Bps = (float)SpeedTestSocket.this.uploadFileSize / ((float)(SpeedTestSocket.this.timeEnd - SpeedTestSocket.this.timeStart) / 1000.0f);
                                        for (int i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                            ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onUploadPacketsReceived(SpeedTestSocket.this.uploadFileSize, transferRate_bps, transferRate_Bps);
                                        }
                                    }
                                    SpeedTestSocket.this.speedTestMode = SpeedTestMode.NONE;
                                    SpeedTestSocket.this.isReading = false;
                                    SpeedTestSocket.this.closeSocket();
                                    SpeedTestSocket.this.executorService.shutdown();
                                    return;
                                }
                                SpeedTestSocket.this.isReading = false;
                                SpeedTestSocket.this.closeSocket();
                                for (int i = 0; i < SpeedTestSocket.this.speedTestListenerList.size(); ++i) {
                                    ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(i)).onUploadError(SpeedTestError.SOCKET_ERROR, "socket error");
                                }
                                SpeedTestSocket.this.executorService.shutdown();
                            }
                            catch (SocketException e) {
                                SpeedTestSocket.this.dispatchError(isDownload, e.getMessage());
                                SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                                SpeedTestSocket.this.executorService.shutdown();
                            }
                            catch (Exception e) {
                                SpeedTestSocket.this.dispatchError(isDownload, e.getMessage());
                                SpeedTestSocket.this.timeEnd = System.currentTimeMillis();
                                SpeedTestSocket.this.executorService.shutdown();
                            }
                        }
                    }
                    SpeedTestSocket.this.speedTestMode = SpeedTestMode.NONE;
                }
            });
            if (task != null) {
                task.run();
            }
        }
        catch (IOException e) {
            this.dispatchError(isDownload, e.getMessage());
        }
    }

    private void dispatchError(boolean isDownload, String errorMessage) {
        if (!this.isForceCloseSocket) {
            if (isDownload) {
                for (int i = 0; i < this.speedTestListenerList.size(); ++i) {
                    this.speedTestListenerList.get(i).onDownloadError(SpeedTestError.CONNECTION_ERROR, errorMessage);
                }
            } else {
                for (int i = 0; i < this.speedTestListenerList.size(); ++i) {
                    this.speedTestListenerList.get(i).onUploadError(SpeedTestError.CONNECTION_ERROR, errorMessage);
                }
            }
        } else if (isDownload) {
            for (int i = 0; i < this.speedTestListenerList.size(); ++i) {
                this.speedTestListenerList.get(i).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, errorMessage + FORCE_CLOSE_CAUSE_MESSAGE);
            }
        } else {
            for (int i = 0; i < this.speedTestListenerList.size(); ++i) {
                this.speedTestListenerList.get(i).onUploadError(SpeedTestError.FORCE_CLOSE_SOCKET, errorMessage + FORCE_CLOSE_CAUSE_MESSAGE);
            }
        }
    }

    public void startDownload(String hostname, int port, String uri) {
        this.isRepeatDownload = false;
        this.isForceCloseSocket = false;
        this.hostname = hostname;
        this.port = port;
        String downloadRequest = "GET " + uri + " HTTP/1.1\r\n" + "Host: " + hostname + "\r\n\r\n";
        this.writeDownload(downloadRequest.getBytes());
    }

    private void startDownloadRepeat(String hostname, int port, String uri) {
        this.hostname = hostname;
        this.port = port;
        String downloadRequest = "GET " + uri + " HTTP/1.1\r\n" + "Host: " + hostname + "\r\n\r\n";
        this.writeDownload(downloadRequest.getBytes());
    }

    public void startDownloadRepeat(final String hostname, final int port, final String uri, int repeatWindow, int reportPeriodMillis, final IRepeatListener repeatListener) {
        this.isRepeatDownload = true;
        this.repeatRequestNum = 0;
        this.repeatPacketSize = 0L;
        this.repeatTemporaryPacketSize = 0L;
        this.repeatTransferRateBps = 0.0f;
        this.repeatFinished = false;
        this.startDateRepeat = 0L;
        this.isFirstDownloadRepeat = true;
        final Timer timer = new Timer();
        final ISpeedTestListener speedTestListener = new ISpeedTestListener(){

            @Override
            public void onDownloadPacketsReceived(long packetSize, float transferRateBitPerSeconds, float transferRateOctetPerSeconds) {
                SpeedTestSocket.this.repeatTransferRateBps = (SpeedTestSocket.this.repeatTransferRateBps + transferRateOctetPerSeconds) / 2.0f;
                SpeedTestSocket.this.startDownloadRepeat(hostname, port, uri);
                SpeedTestSocket.this.repeatRequestNum++;
            }

            @Override
            public void onDownloadProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onDownloadError(SpeedTestError speedTestError, String errorMessage) {
                SpeedTestSocket.this.removeSpeedTestListener(this);
                timer.cancel();
                timer.purge();
                SpeedTestSocket.this.repeatFinished = true;
                SpeedTestSocket.this.closeSocket();
                SpeedTestSocket.this.executorService.shutdownNow();
            }

            @Override
            public void onUploadPacketsReceived(long packetSize, float transferRateBitPerSeconds, float transferRateOctetPerSeconds) {
            }

            @Override
            public void onUploadError(SpeedTestError speedTestError, String errorMessage) {
                SpeedTestSocket.this.removeSpeedTestListener(this);
                timer.cancel();
                timer.purge();
                SpeedTestSocket.this.repeatFinished = true;
                SpeedTestSocket.this.closeSocket();
                SpeedTestSocket.this.executorService.shutdownNow();
            }

            @Override
            public void onUploadProgress(float percent, SpeedTestReport report) {
            }
        };
        this.addSpeedTestListener(speedTestListener);
        this.repeatWindows = repeatWindow;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SpeedTestSocket.this.removeSpeedTestListener(speedTestListener);
                SpeedTestSocket.this.forceStopTask();
                timer.cancel();
                timer.purge();
                SpeedTestSocket.this.repeatFinished = true;
                if (repeatListener != null) {
                    repeatListener.onFinish(SpeedTestSocket.this.getLiveDownloadReport());
                }
            }
        }, repeatWindow);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (repeatListener != null) {
                    repeatListener.onReport(SpeedTestSocket.this.getLiveDownloadReport());
                }
            }
        }, reportPeriodMillis, (long)reportPeriodMillis);
        this.startDownloadRepeat(hostname, port, uri);
    }

    public void forceStopTask() {
        this.isForceCloseSocket = true;
        this.closeSocket();
        this.executorService.shutdownNow();
    }

    public void writeDownload(final byte[] data) {
        this.speedTestMode = SpeedTestMode.DOWNLOAD;
        this.connectAndExecuteTask(new TimerTask(){

            @Override
            public void run() {
                if (SpeedTestSocket.this.socket != null && !SpeedTestSocket.this.socket.isClosed()) {
                    try {
                        if (SpeedTestSocket.this.socket.getOutputStream() != null) {
                            SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                            SpeedTestSocket.this.socket.getOutputStream().write(data);
                            SpeedTestSocket.this.socket.getOutputStream().flush();
                        }
                    }
                    catch (IOException e) {
                        SpeedTestSocket.this.dispatchError(true, e.getMessage());
                    }
                }
            }
        }, true);
    }

    public void startUpload(String hostname, int port, String uri, int fileSizeOctet) {
        this.hostname = hostname;
        this.port = port;
        this.uploadFileSize = fileSizeOctet;
        this.timeEnd = 0L;
        this.isForceCloseSocket = false;
        RandomGen random = new RandomGen(fileSizeOctet);
        byte[] fileContent = random.nextArray();
        String uploadRequest = "POST " + uri + " HTTP/1.1\r\n" + "Host: " + hostname + "\r\nAccept: */*\r\nContent-Length: " + fileSizeOctet + "\r\n\r\n";
        this.writeUpload(uploadRequest.getBytes(), fileContent);
    }

    private void writeUpload(final byte[] head, final byte[] body) {
        this.speedTestMode = SpeedTestMode.UPLOAD;
        this.connectAndExecuteTask(new TimerTask(){

            @Override
            public void run() {
                if (SpeedTestSocket.this.socket != null && !SpeedTestSocket.this.socket.isClosed()) {
                    try {
                        SpeedTestSocket.this.uploadTemporaryFileSize = 0;
                        int step = body.length / SpeedTestSocket.this.uploadChunkSize;
                        int remain = body.length % SpeedTestSocket.this.uploadChunkSize;
                        if (SpeedTestSocket.this.socket.getOutputStream() != null) {
                            SpeedTestSocket.this.socket.getOutputStream().write(head);
                            SpeedTestSocket.this.socket.getOutputStream().flush();
                            SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                            for (int i = 0; i < step; ++i) {
                                SpeedTestSocket.this.socket.getOutputStream().write(Arrays.copyOfRange(body, SpeedTestSocket.this.uploadTemporaryFileSize, SpeedTestSocket.this.uploadTemporaryFileSize + SpeedTestSocket.this.uploadChunkSize));
                                SpeedTestSocket.this.socket.getOutputStream().flush();
                                for (int j = 0; j < SpeedTestSocket.this.speedTestListenerList.size(); ++j) {
                                    SpeedTestReport report = SpeedTestSocket.this.getLiveUploadReport();
                                    ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(j)).onUploadProgress(report.getProgressPercent(), report);
                                }
                                SpeedTestSocket.this.uploadTemporaryFileSize += SpeedTestSocket.this.uploadChunkSize;
                            }
                            if (remain != 0) {
                                SpeedTestSocket.this.socket.getOutputStream().write(Arrays.copyOfRange(body, SpeedTestSocket.this.uploadTemporaryFileSize, SpeedTestSocket.this.uploadTemporaryFileSize + remain));
                                SpeedTestSocket.this.socket.getOutputStream().flush();
                            }
                            for (int j = 0; j < SpeedTestSocket.this.speedTestListenerList.size(); ++j) {
                                ((ISpeedTestListener)SpeedTestSocket.this.speedTestListenerList.get(j)).onUploadProgress(100.0f, SpeedTestSocket.this.getLiveUploadReport());
                            }
                        }
                    }
                    catch (IOException e) {
                        SpeedTestSocket.this.dispatchError(false, e.getMessage());
                        SpeedTestSocket.this.executorService.shutdown();
                    }
                }
            }
        }, false);
    }

    public SpeedTestReport getLiveDownloadReport() {
        return this.getReport(SpeedTestMode.DOWNLOAD);
    }

    public SpeedTestReport getLiveUploadReport() {
        return this.getReport(SpeedTestMode.UPLOAD);
    }

    private SpeedTestReport getReport(SpeedTestMode mode) {
        long temporaryPacketSize = 0L;
        long totalPacketSize = 0L;
        switch (mode) {
            case DOWNLOAD: {
                temporaryPacketSize = this.downloadTemporaryPacketSize;
                totalPacketSize = this.downloadPacketSize;
                break;
            }
            case UPLOAD: {
                temporaryPacketSize = this.uploadTemporaryFileSize;
                totalPacketSize = this.uploadFileSize;
            }
        }
        long currentTime = this.timeEnd == 0L ? System.currentTimeMillis() : this.timeEnd;
        float transferRate_bps = (float)(temporaryPacketSize * 8L) / ((float)(currentTime - this.timeStart) / 1000.0f);
        float transferRate_Bps = (float)temporaryPacketSize / ((float)(currentTime - this.timeStart) / 1000.0f);
        float percent = 0.0f;
        long timeStartReport = this.timeStart;
        int requestNum = 1;
        if (this.isRepeatDownload) {
            percent = this.startDateRepeat != 0L ? (!this.repeatFinished ? (float)(System.currentTimeMillis() - this.startDateRepeat) * 100.0f / (float)this.repeatWindows : 100.0f) : 0.0f;
            if (this.repeatTransferRateBps != 0.0f && !this.repeatFinished) {
                transferRate_Bps = (this.repeatTransferRateBps + transferRate_Bps) / 2.0f;
            } else if (this.repeatFinished) {
                transferRate_Bps = this.repeatTransferRateBps;
            }
            transferRate_bps = transferRate_Bps * 8.0f;
            timeStartReport = this.startDateRepeat;
            requestNum = this.repeatRequestNum;
            totalPacketSize = this.repeatPacketSize;
            temporaryPacketSize = !this.repeatFinished ? this.repeatTemporaryPacketSize : totalPacketSize;
            if (this.repeatFinished) {
                currentTime = this.startDateRepeat + (long)this.repeatWindows;
            }
        } else if (totalPacketSize != 0L) {
            percent = (float)temporaryPacketSize * 100.0f / (float)totalPacketSize;
        }
        return new SpeedTestReport(mode, percent, timeStartReport, currentTime, temporaryPacketSize, totalPacketSize, transferRate_Bps, transferRate_bps, requestNum);
    }

    public void closeSocket() {
        if (this.socket != null) {
            try {
                this.socket.getOutputStream().close();
                this.socket.getInputStream().close();
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    public void closeSocketJoinRead() {
        this.isReading = false;
        this.executorService.shutdown();
        while (!this.executorService.isTerminated()) {
        }
        this.closeSocket();
    }

    public SpeedTestMode getSpeedTestMode() {
        return this.speedTestMode;
    }

    public int getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    public void setSocketTimeout(int socketTimeoutMillis) {
        this.socketTimeout = socketTimeoutMillis;
    }

    public void setUploadChunkSize(int uploadChunkSize) {
        this.uploadChunkSize = uploadChunkSize;
    }
}

