/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.protocol.http.HttpFrame;
import fr.bmartel.protocol.http.states.HttpStates;
import fr.bmartel.speedtest.IRepeatListener;
import fr.bmartel.speedtest.ISpeedTestListener;
import fr.bmartel.speedtest.RandomGen;
import fr.bmartel.speedtest.SpeedTestError;
import fr.bmartel.speedtest.SpeedTestMode;
import fr.bmartel.speedtest.SpeedTestReport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SpeedTestSocket {
    private static final int READ_BUFFER_SIZE = 65535;
    private static final int DEFAULT_UPLOAD_SIZE = 65535;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int HTTP_OK = 200;
    private static final float PERCENT_MAX = 100.0f;
    private static final float MILLIS_DIVIDER = 1000.0f;
    private static final byte BIT_MULTIPLIER = 8;
    private static final String PARSING_ERROR = "Error occurred while parsing ";
    private static final String PARSING_HTTP_ERROR = "Error occurred while parsing http ";
    private static final String SOCKET_WRITE_ERROR = "Error occurred while writing to socket";
    private String hostname = "";
    private int port;
    private Socket socket;
    private final List<ISpeedTestListener> listenerList = new ArrayList<ISpeedTestListener>();
    private int uploadChunkSize = 65535;
    private int socketTimeout = 10000;
    private boolean forceCloseSocket;
    private static final int THREAD_POOL_SIZE = 1;
    private ScheduledExecutorService executorService;
    private static final String FORCE_CLOSE_CAUSE_MESSAGE = " caused by socket force close";
    private long uploadFileSize;
    private long timeStart;
    private long timeEnd;
    private SpeedTestMode speedTestMode = SpeedTestMode.NONE;
    private int uploadTempFileSize;
    private int downloadTemporaryPacketSize;
    private long downloadPckSize;
    private boolean isRepeatDownload;
    private long startDateRepeat;
    private int repeatWindows;
    private int repeatRequestNum;
    private long repeatPacketSize;
    private long repeatTempPckSize;
    private float repeatTransferRateBps;
    private boolean isFirstDownloadRepeat;
    private boolean repeatFinished;
    private boolean errorDispatched;

    public SpeedTestSocket() {
        this.initThreadPool();
    }

    public void addSpeedTestListener(ISpeedTestListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSpeedTestListener(ISpeedTestListener listener) {
        this.listenerList.remove(listener);
    }

    private void initThreadPool() {
        this.executorService = Executors.newScheduledThreadPool(1);
    }

    private void connectAndExecuteTask(TimerTask task, final boolean isDownload) {
        block5: {
            if (this.socket != null) {
                this.closeSocket();
            }
            try {
                this.socket = new Socket();
                if (this.socketTimeout != 0 && isDownload) {
                    this.socket.setSoTimeout(this.socketTimeout);
                }
                this.socket.setReuseAddress(true);
                this.socket.setKeepAlive(true);
                this.socket.connect(new InetSocketAddress(this.hostname, this.port));
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (isDownload) {
                            SpeedTestSocket.this.startSocketDownloadTask();
                        } else {
                            SpeedTestSocket.this.startSocketUploadTask();
                        }
                        SpeedTestSocket.this.speedTestMode = SpeedTestMode.NONE;
                    }
                });
                if (task != null) {
                    task.run();
                }
            }
            catch (IOException e) {
                if (this.errorDispatched) break block5;
                this.dispatchError(isDownload, e.getMessage());
            }
        }
    }

    private void startSocketDownloadTask() {
        this.downloadTemporaryPacketSize = 0;
        try {
            HttpFrame httpFrame = new HttpFrame();
            this.timeStart = System.currentTimeMillis();
            if (this.isFirstDownloadRepeat && this.isRepeatDownload) {
                this.isFirstDownloadRepeat = false;
                this.startDateRepeat = this.timeStart;
            }
            this.timeEnd = 0L;
            HttpStates httFrameState = httpFrame.decodeFrame(this.socket.getInputStream());
            this.checkHttpFrameError(httFrameState);
            HttpStates httpHeaderState = httpFrame.parseHeader(this.socket.getInputStream());
            this.checkHttpHeaderError(httpHeaderState);
            this.checkHttpContentLengthError(httpFrame);
            this.downloadPckSize = httpFrame.getContentLength();
            if (this.isRepeatDownload) {
                this.repeatPacketSize += this.downloadPckSize;
            }
            this.downloadReadingLoop();
            this.timeEnd = System.currentTimeMillis();
            float transferRateOps = (float)this.downloadPckSize / ((float)(this.timeEnd - this.timeStart) / 1000.0f);
            float transferRateBps = transferRateOps * 8.0f;
            this.closeSocket();
            for (int i = 0; i < this.listenerList.size(); ++i) {
                this.listenerList.get(i).onDownloadPacketsReceived(this.downloadPckSize, transferRateBps, transferRateOps);
            }
            if (!this.isRepeatDownload) {
                this.executorService.shutdownNow();
            }
        }
        catch (SocketTimeoutException e) {
            this.dispatchSocketTimeout(true, e.getMessage());
            this.timeEnd = System.currentTimeMillis();
            this.closeSocket();
            this.executorService.shutdownNow();
        }
        catch (IOException e) {
            this.catchError(true, e.getMessage());
        }
        catch (InterruptedException e) {
            this.catchError(true, e.getMessage());
        }
        this.errorDispatched = false;
    }

    private void downloadReadingLoop() throws IOException {
        byte[] buffer = new byte[65535];
        int read = 0;
        while ((read = this.socket.getInputStream().read(buffer)) != -1) {
            this.downloadTemporaryPacketSize += read;
            if (this.isRepeatDownload) {
                this.repeatTempPckSize += (long)read;
            }
            for (int i = 0; i < this.listenerList.size(); ++i) {
                SpeedTestReport report = this.getLiveDownloadReport();
                this.listenerList.get(i).onDownloadProgress(report.getProgressPercent(), this.getLiveDownloadReport());
            }
            if ((long)this.downloadTemporaryPacketSize != this.downloadPckSize) continue;
            break;
        }
    }

    private void checkHttpFrameError(HttpStates httFrameState) {
        block4: {
            if (httFrameState == HttpStates.HTTP_FRAME_OK) break block4;
            if (!this.forceCloseSocket) {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error occurred while parsing http frame");
                }
            } else {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, "Error occurred while parsing http frame caused by socket force close");
                }
            }
        }
    }

    private void checkHttpHeaderError(HttpStates httpHeaderState) {
        block4: {
            if (httpHeaderState == HttpStates.HTTP_FRAME_OK) break block4;
            if (!this.forceCloseSocket) {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error occurred while parsing http headers");
                }
            } else {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, "Error occurred while parsing http headers caused by socket force close");
                }
            }
        }
    }

    private void checkHttpContentLengthError(HttpFrame httpFrame) {
        block4: {
            if (httpFrame.getContentLength() >= 0) break block4;
            if (!this.forceCloseSocket) {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error content length is inconsistent");
                }
            } else {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, "Error content length is inconsistent caused by socket force close");
                }
            }
        }
    }

    private void startSocketUploadTask() {
        block11: {
            try {
                HttpFrame frame = new HttpFrame();
                HttpStates httpStates = frame.parseHttp(this.socket.getInputStream());
                if (httpStates == HttpStates.HTTP_FRAME_OK) {
                    if (frame.getStatusCode() == 200 && frame.getReasonPhrase().equalsIgnoreCase("ok")) {
                        this.timeEnd = System.currentTimeMillis();
                        float transferRateOps = (float)this.uploadFileSize / ((float)(this.timeEnd - this.timeStart) / 1000.0f);
                        float transferRateBps = transferRateOps * 8.0f;
                        for (int i = 0; i < this.listenerList.size(); ++i) {
                            this.listenerList.get(i).onUploadPacketsReceived(this.uploadFileSize, transferRateBps, transferRateOps);
                        }
                    }
                    this.speedTestMode = SpeedTestMode.NONE;
                    this.closeSocket();
                    this.executorService.shutdownNow();
                    return;
                }
                this.closeSocket();
                if (!this.errorDispatched && !this.forceCloseSocket) {
                    for (int i = 0; i < this.listenerList.size(); ++i) {
                        this.listenerList.get(i).onUploadError(SpeedTestError.SOCKET_ERROR, "socket error");
                    }
                }
                this.executorService.shutdownNow();
            }
            catch (SocketException e) {
                if (!this.errorDispatched) {
                    this.catchError(false, e.getMessage());
                }
            }
            catch (IOException e) {
                if (!this.errorDispatched) {
                    this.catchError(true, e.getMessage());
                }
            }
            catch (InterruptedException e) {
                if (this.errorDispatched) break block11;
                this.catchError(true, e.getMessage());
            }
        }
        this.errorDispatched = false;
    }

    private void catchError(boolean isDownload, String errorMessage) {
        this.dispatchError(isDownload, errorMessage);
        this.timeEnd = System.currentTimeMillis();
        this.closeSocket();
        this.executorService.shutdownNow();
    }

    private void dispatchError(boolean isDownload, String errorMessage) {
        if (!this.forceCloseSocket) {
            if (isDownload) {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.CONNECTION_ERROR, errorMessage);
                }
            } else {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onUploadError(SpeedTestError.CONNECTION_ERROR, errorMessage);
                }
            }
        } else if (isDownload) {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                this.listenerList.get(i).onDownloadError(SpeedTestError.FORCE_CLOSE_SOCKET, errorMessage + FORCE_CLOSE_CAUSE_MESSAGE);
            }
        } else {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                this.listenerList.get(i).onUploadError(SpeedTestError.FORCE_CLOSE_SOCKET, errorMessage + FORCE_CLOSE_CAUSE_MESSAGE);
            }
        }
    }

    private void dispatchSocketTimeout(boolean isDownload, String errorMessage) {
        block4: {
            if (this.forceCloseSocket) break block4;
            if (isDownload) {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onDownloadError(SpeedTestError.SOCKET_TIMEOUT, errorMessage);
                }
            } else {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    this.listenerList.get(i).onUploadError(SpeedTestError.SOCKET_TIMEOUT, errorMessage);
                }
            }
        }
    }

    private void startDownloadRequest(String hostname, int port, String uri) {
        this.forceCloseSocket = false;
        this.hostname = hostname;
        this.port = port;
        String downloadRequest = "GET " + uri + " HTTP/1.1\r\n" + "Host: " + hostname + "\r\n\r\n";
        this.writeDownload(downloadRequest.getBytes());
    }

    public void startDownload(String hostname, int port, String uri) {
        this.isRepeatDownload = false;
        this.errorDispatched = false;
        this.startDownloadRequest(hostname, port, uri);
    }

    private void startDownloadRepeat(String hostname, int port, String uri) {
        this.errorDispatched = false;
        this.startDownloadRequest(hostname, port, uri);
    }

    public void startDownloadRepeat(final String hostname, final int port, final String uri, int repeatWindow, int reportPeriodMillis, final IRepeatListener repeatListener) {
        this.initDownloadRepeat();
        final Timer timer = new Timer();
        final ISpeedTestListener speedTestListener = new ISpeedTestListener(){

            @Override
            public void onDownloadPacketsReceived(long packetSize, float transferRateBitPerSeconds, float transferRateOctetPerSeconds) {
                SpeedTestSocket.this.repeatTransferRateBps = (SpeedTestSocket.this.repeatTransferRateBps + transferRateOctetPerSeconds) / 2.0f;
                SpeedTestSocket.this.startDownloadRepeat(hostname, port, uri);
                SpeedTestSocket.this.repeatRequestNum++;
            }

            @Override
            public void onDownloadProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onDownloadError(SpeedTestError speedTestError, String errorMessage) {
                SpeedTestSocket.this.clearDownloadRepeat(this, timer);
            }

            @Override
            public void onUploadPacketsReceived(long packetSize, float transferRateBitPerSeconds, float transferRateOctetPerSeconds) {
            }

            @Override
            public void onUploadError(SpeedTestError speedTestError, String errorMessage) {
                SpeedTestSocket.this.clearDownloadRepeat(this, timer);
            }

            @Override
            public void onUploadProgress(float percent, SpeedTestReport report) {
            }
        };
        this.addSpeedTestListener(speedTestListener);
        this.repeatWindows = repeatWindow;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SpeedTestSocket.this.removeSpeedTestListener(speedTestListener);
                SpeedTestSocket.this.forceStopTask();
                timer.cancel();
                timer.purge();
                SpeedTestSocket.this.repeatFinished = true;
                if (repeatListener != null) {
                    repeatListener.onFinish(SpeedTestSocket.this.getLiveDownloadReport());
                }
            }
        }, repeatWindow);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (repeatListener != null) {
                    repeatListener.onReport(SpeedTestSocket.this.getLiveDownloadReport());
                }
            }
        }, reportPeriodMillis, (long)reportPeriodMillis);
        this.startDownloadRepeat(hostname, port, uri);
    }

    private void initDownloadRepeat() {
        this.isRepeatDownload = true;
        this.repeatRequestNum = 0;
        this.repeatPacketSize = 0L;
        this.repeatTempPckSize = 0L;
        this.repeatTransferRateBps = 0.0f;
        this.repeatFinished = false;
        this.startDateRepeat = 0L;
        this.isFirstDownloadRepeat = true;
    }

    private void clearDownloadRepeat(ISpeedTestListener listener, Timer timer) {
        this.removeSpeedTestListener(listener);
        if (timer != null) {
            timer.cancel();
            timer.purge();
        }
        this.repeatFinished = true;
        this.closeSocket();
        this.executorService.shutdownNow();
    }

    public void forceStopTask() {
        this.forceCloseSocket = true;
        this.closeSocket();
        this.executorService.shutdownNow();
    }

    private void writeDownload(final byte[] data) {
        this.speedTestMode = SpeedTestMode.DOWNLOAD;
        this.connectAndExecuteTask(new TimerTask(){

            @Override
            public void run() {
                if (SpeedTestSocket.this.socket != null && !SpeedTestSocket.this.socket.isClosed()) {
                    try {
                        if (SpeedTestSocket.this.socket.getOutputStream() != null) {
                            SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                            if (SpeedTestSocket.this.writeFlushSocket(data) != 0) {
                                throw new SocketTimeoutException();
                            }
                        }
                    }
                    catch (SocketTimeoutException e) {
                        SpeedTestSocket.this.dispatchSocketTimeout(true, SpeedTestSocket.SOCKET_WRITE_ERROR);
                        SpeedTestSocket.this.closeSocket();
                        SpeedTestSocket.this.executorService.shutdownNow();
                    }
                    catch (IOException e) {
                        SpeedTestSocket.this.dispatchError(true, e.getMessage());
                        SpeedTestSocket.this.executorService.shutdownNow();
                    }
                }
            }
        }, true);
    }

    public void startUpload(String hostname, int port, String uri, int fileSizeOctet) {
        this.hostname = hostname;
        this.port = port;
        this.uploadFileSize = fileSizeOctet;
        this.timeEnd = 0L;
        this.forceCloseSocket = false;
        this.errorDispatched = false;
        byte[] fileContent = new RandomGen(fileSizeOctet).nextArray();
        String uploadRequest = "POST " + uri + " HTTP/1.1\r\n" + "Host: " + hostname + "\r\nAccept: " + "*/*\r\nContent-Length: " + fileSizeOctet + "\r\n\r\n";
        this.writeUpload(uploadRequest.getBytes(), fileContent);
    }

    private void writeUpload(final byte[] head, final byte[] body) {
        this.speedTestMode = SpeedTestMode.UPLOAD;
        this.connectAndExecuteTask(new TimerTask(){

            @Override
            public void run() {
                if (SpeedTestSocket.this.socket != null && !SpeedTestSocket.this.socket.isClosed()) {
                    try {
                        SpeedTestSocket.this.uploadTempFileSize = 0;
                        int step = body.length / SpeedTestSocket.this.uploadChunkSize;
                        int remain = body.length % SpeedTestSocket.this.uploadChunkSize;
                        if (SpeedTestSocket.this.socket.getOutputStream() != null) {
                            if (SpeedTestSocket.this.writeFlushSocket(head) != 0) {
                                throw new SocketTimeoutException();
                            }
                            SpeedTestSocket.this.timeStart = System.currentTimeMillis();
                            for (int i = 0; i < step; ++i) {
                                if (SpeedTestSocket.this.writeFlushSocket(Arrays.copyOfRange(body, SpeedTestSocket.this.uploadTempFileSize, SpeedTestSocket.this.uploadTempFileSize + SpeedTestSocket.this.uploadChunkSize)) != 0) {
                                    throw new SocketTimeoutException();
                                }
                                for (int j = 0; j < SpeedTestSocket.this.listenerList.size(); ++j) {
                                    SpeedTestReport report = SpeedTestSocket.this.getLiveUploadReport();
                                    ((ISpeedTestListener)SpeedTestSocket.this.listenerList.get(j)).onUploadProgress(report.getProgressPercent(), report);
                                }
                                SpeedTestSocket.this.uploadTempFileSize += SpeedTestSocket.this.uploadChunkSize;
                            }
                            if (remain != 0 && SpeedTestSocket.this.writeFlushSocket(Arrays.copyOfRange(body, SpeedTestSocket.this.uploadTempFileSize, SpeedTestSocket.this.uploadTempFileSize + remain)) != 0) {
                                throw new SocketTimeoutException();
                            }
                            for (int j = 0; j < SpeedTestSocket.this.listenerList.size(); ++j) {
                                ((ISpeedTestListener)SpeedTestSocket.this.listenerList.get(j)).onUploadProgress(100.0f, SpeedTestSocket.this.getLiveUploadReport());
                            }
                        }
                    }
                    catch (SocketTimeoutException e) {
                        SpeedTestSocket.this.errorDispatched = true;
                        SpeedTestSocket.this.dispatchSocketTimeout(false, SpeedTestSocket.SOCKET_WRITE_ERROR);
                        SpeedTestSocket.this.closeSocket();
                        SpeedTestSocket.this.executorService.shutdownNow();
                    }
                    catch (IOException e) {
                        SpeedTestSocket.this.errorDispatched = true;
                        SpeedTestSocket.this.dispatchError(false, e.getMessage());
                        SpeedTestSocket.this.executorService.shutdownNow();
                    }
                }
            }
        }, false);
    }

    private int writeFlushSocket(final byte[] data) throws IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(new Callable(){

            public Integer call() {
                try {
                    SpeedTestSocket.this.socket.getOutputStream().write(data);
                    SpeedTestSocket.this.socket.getOutputStream().flush();
                }
                catch (IOException e) {
                    return -1;
                }
                return 0;
            }
        });
        try {
            future.get(this.socketTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            executor.shutdownNow();
            return -1;
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            return -1;
        }
        catch (ExecutionException e) {
            executor.shutdownNow();
            return -1;
        }
        executor.shutdownNow();
        return 0;
    }

    public SpeedTestReport getLiveDownloadReport() {
        return this.getReport(SpeedTestMode.DOWNLOAD);
    }

    public SpeedTestReport getLiveUploadReport() {
        return this.getReport(SpeedTestMode.UPLOAD);
    }

    private SpeedTestReport getReport(SpeedTestMode mode) {
        SpeedTestReport report;
        long temporaryPacketSize = 0L;
        long totalPacketSize = 0L;
        switch (mode) {
            case DOWNLOAD: {
                temporaryPacketSize = this.downloadTemporaryPacketSize;
                totalPacketSize = this.downloadPckSize;
                break;
            }
            case UPLOAD: {
                temporaryPacketSize = this.uploadTempFileSize;
                totalPacketSize = this.uploadFileSize;
                break;
            }
        }
        long currentTime = this.timeEnd == 0L ? System.currentTimeMillis() : this.timeEnd;
        float transferRateOps = (float)temporaryPacketSize / ((float)(currentTime - this.timeStart) / 1000.0f);
        float transferRateBitps = transferRateOps * 8.0f;
        float percent = 0.0f;
        if (this.isRepeatDownload) {
            report = this.getRepeatDownloadReport(mode, currentTime, transferRateOps);
        } else {
            if (totalPacketSize != 0L) {
                percent = (float)temporaryPacketSize * 100.0f / (float)totalPacketSize;
            }
            report = new SpeedTestReport(mode, percent, this.timeStart, currentTime, temporaryPacketSize, totalPacketSize, transferRateOps, transferRateBitps, 1);
        }
        return report;
    }

    private SpeedTestReport getRepeatDownloadReport(SpeedTestMode speedTestMode, long reportTime, float transferRateOctet) {
        float progressPercent = 0.0f;
        long temporaryPacketSize = 0L;
        float transferRateBit = 0.0f;
        float downloadRepeatRateOctet = transferRateOctet;
        long downloadRepeatReportTime = reportTime;
        progressPercent = this.startDateRepeat != 0L ? (!this.repeatFinished ? (float)(System.currentTimeMillis() - this.startDateRepeat) * 100.0f / (float)this.repeatWindows : 100.0f) : 0.0f;
        if (this.repeatTransferRateBps != 0.0f && !this.repeatFinished) {
            downloadRepeatRateOctet = (this.repeatTransferRateBps + downloadRepeatRateOctet) / 2.0f;
        } else if (this.repeatFinished) {
            downloadRepeatRateOctet = transferRateOctet;
        }
        transferRateBit = downloadRepeatRateOctet * 8.0f;
        temporaryPacketSize = !this.repeatFinished ? this.repeatTempPckSize : this.repeatPacketSize;
        if (this.repeatFinished) {
            downloadRepeatReportTime = this.startDateRepeat + (long)this.repeatWindows;
        }
        return new SpeedTestReport(speedTestMode, progressPercent, this.startDateRepeat, downloadRepeatReportTime, temporaryPacketSize, this.repeatPacketSize, downloadRepeatRateOctet, transferRateBit, this.repeatRequestNum);
    }

    public void closeSocket() {
        if (this.socket != null) {
            try {
                this.socket.getInputStream().close();
                this.socket.getOutputStream().close();
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public SpeedTestMode getSpeedTestMode() {
        return this.speedTestMode;
    }

    public void setSocketTimeout(int socketTimeoutMillis) {
        if (socketTimeoutMillis >= 0) {
            this.socketTimeout = socketTimeoutMillis;
        }
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    public void setUploadChunkSize(int uploadChunkSize) {
        this.uploadChunkSize = uploadChunkSize;
    }
}

