/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import java.util.Arrays;
import java.util.Random;

public class RandomGen {
    private static final byte[] SYMBOLS = new byte[255];
    private static final int SYMBOLS_LENGTH = 255;
    private static final int MINIMUM_LENGTH = 1;
    private final Random random = new Random();
    private final byte[] buf;

    public RandomGen(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length < 1: " + length);
        }
        this.buf = new byte[length];
    }

    public byte[] nextArray() {
        for (int idx = 0; idx < this.buf.length; ++idx) {
            int val = this.random.nextInt(255);
            this.buf[idx] = SYMBOLS[val];
        }
        return Arrays.copyOf(this.buf, this.buf.length);
    }

    static {
        for (int i = 0; i < 255; ++i) {
            RandomGen.SYMBOLS[i] = (byte)i;
        }
    }
}

