/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import java.util.Arrays;
import java.util.Random;

public class RandomGen {
    private static final byte[] SYMBOLS = new byte[255];
    private static final int SYMBOLS_LENGTH = 255;
    private static final int MINIMUM_LENGTH = 1;
    private final Random mRandom = new Random();
    private final byte[] mBuf;

    public RandomGen(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length < 1: " + length);
        }
        this.mBuf = new byte[length];
    }

    public byte[] nextArray() {
        for (int idx = 0; idx < this.mBuf.length; ++idx) {
            int val = this.mRandom.nextInt(255);
            this.mBuf[idx] = SYMBOLS[val];
        }
        return Arrays.copyOf(this.mBuf, this.mBuf.length);
    }

    static {
        for (int i = 0; i < 255; ++i) {
            RandomGen.SYMBOLS[i] = (byte)i;
        }
    }
}

