/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.speedtest.IRepeatListener;
import fr.bmartel.speedtest.ISpeedTestListener;
import fr.bmartel.speedtest.ISpeedTestSocket;
import fr.bmartel.speedtest.SpeedTestConst;
import fr.bmartel.speedtest.SpeedTestError;
import fr.bmartel.speedtest.SpeedTestMode;
import fr.bmartel.speedtest.SpeedTestReport;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class RepeatWrapper {
    private List<BigDecimal> mRepeatTransferRateList = new ArrayList<BigDecimal>();
    private boolean mRepeatFinished;
    private long mRepeatTempPckSize;
    private boolean mRepeatUpload;
    private long mStartDateRepeat;
    private int mRepeatWindows;
    private int mRepeatRequestNum;
    private boolean mRepeatDownload;
    private BigDecimal mRepeatPacketSize = BigDecimal.ZERO;
    private boolean mFirstDownloadRepeat;
    private boolean mFirstUploadRepeat;
    private final ISpeedTestSocket mSpeedTestSocket;

    public RepeatWrapper(ISpeedTestSocket socket) {
        this.mSpeedTestSocket = socket;
    }

    public SpeedTestReport getRepeatReport(int scale, RoundingMode roundingMode, SpeedTestMode speedTestMode, long reportTime, BigDecimal transferRateOctet) {
        BigDecimal progressPercent = BigDecimal.ZERO;
        long temporaryPacketSize = 0L;
        BigDecimal downloadRepeatRateOctet = transferRateOctet;
        long downloadRepeatReportTime = reportTime;
        progressPercent = this.mStartDateRepeat != 0L ? (!this.mRepeatFinished ? new BigDecimal(System.currentTimeMillis() - this.mStartDateRepeat).multiply(SpeedTestConst.PERCENT_MAX).divide(new BigDecimal(this.mRepeatWindows), scale, roundingMode) : SpeedTestConst.PERCENT_MAX) : BigDecimal.ZERO;
        BigDecimal rates = BigDecimal.ZERO;
        for (BigDecimal rate : this.mRepeatTransferRateList) {
            rates = rates.add(rate);
        }
        if (!this.mRepeatTransferRateList.isEmpty()) {
            downloadRepeatRateOctet = rates.add(downloadRepeatRateOctet).divide(new BigDecimal(this.mRepeatTransferRateList.size()).add(new BigDecimal(this.mRepeatTempPckSize).divide(this.mRepeatPacketSize, scale, roundingMode)), scale, roundingMode);
        }
        BigDecimal transferRateBit = downloadRepeatRateOctet.multiply(SpeedTestConst.BIT_MULTIPLIER);
        if (!this.mRepeatFinished) {
            temporaryPacketSize = this.mRepeatTempPckSize;
        } else {
            temporaryPacketSize = this.mRepeatTempPckSize;
            downloadRepeatReportTime = this.mStartDateRepeat + (long)this.mRepeatWindows;
        }
        return new SpeedTestReport(speedTestMode, progressPercent.floatValue(), this.mStartDateRepeat, downloadRepeatReportTime, temporaryPacketSize, this.mRepeatPacketSize.longValueExact(), downloadRepeatRateOctet, transferRateBit, this.mRepeatRequestNum);
    }

    private void startDownloadRepeat(String hostname, int port, String uri) {
        this.mRepeatDownload = true;
        this.mSpeedTestSocket.startDownload(hostname, port, uri);
    }

    private void startUploadRepeat(String hostname, int port, String uri, int fileSizeOctet) {
        this.mSpeedTestSocket.startUpload(hostname, port, uri, fileSizeOctet);
    }

    public void startDownloadRepeat(final String hostname, final int port, final String uri, int repeatWindow, int reportPeriodMillis, final IRepeatListener repeatListener) {
        this.initRepeat(true);
        final Timer timer = new Timer();
        final ISpeedTestListener speedTestListener = new ISpeedTestListener(){

            @Override
            public void onDownloadFinished(SpeedTestReport report) {
                RepeatWrapper.this.mRepeatTransferRateList.add(report.getTransferRateOctet());
                RepeatWrapper.this.startDownloadRepeat(hostname, port, uri);
                RepeatWrapper.this.mRepeatRequestNum++;
            }

            @Override
            public void onDownloadProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onDownloadError(SpeedTestError speedTestError, String errorMessage) {
                RepeatWrapper.this.clearRepeatTask(this, timer);
            }

            @Override
            public void onUploadFinished(SpeedTestReport report) {
            }

            @Override
            public void onUploadError(SpeedTestError speedTestError, String errorMessage) {
                RepeatWrapper.this.clearRepeatTask(this, timer);
            }

            @Override
            public void onUploadProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onInterruption() {
            }
        };
        this.mSpeedTestSocket.addSpeedTestListener(speedTestListener);
        this.mRepeatWindows = repeatWindow;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RepeatWrapper.this.mSpeedTestSocket.removeSpeedTestListener(speedTestListener);
                RepeatWrapper.this.mSpeedTestSocket.forceStopTask();
                timer.cancel();
                timer.purge();
                RepeatWrapper.this.mRepeatFinished = true;
                if (repeatListener != null) {
                    repeatListener.onFinish(RepeatWrapper.this.mSpeedTestSocket.getLiveDownloadReport());
                }
            }
        }, repeatWindow);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (repeatListener != null) {
                    repeatListener.onReport(RepeatWrapper.this.mSpeedTestSocket.getLiveDownloadReport());
                }
            }
        }, reportPeriodMillis, (long)reportPeriodMillis);
        this.startDownloadRepeat(hostname, port, uri);
    }

    public void startUploadRepeat(final String hostname, final int port, final String uri, int repeatWindow, int reportPeriodMillis, final int fileSizeOctet, final IRepeatListener repeatListener) {
        this.initRepeat(false);
        final Timer timer = new Timer();
        final ISpeedTestListener speedTestListener = new ISpeedTestListener(){

            @Override
            public void onDownloadFinished(SpeedTestReport report) {
            }

            @Override
            public void onDownloadProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onDownloadError(SpeedTestError speedTestError, String errorMessage) {
                RepeatWrapper.this.clearRepeatTask(this, timer);
            }

            @Override
            public void onUploadFinished(SpeedTestReport report) {
                RepeatWrapper.this.mRepeatTransferRateList.add(report.getTransferRateOctet());
                RepeatWrapper.this.startUploadRepeat(hostname, port, uri, fileSizeOctet);
                RepeatWrapper.this.mRepeatRequestNum++;
            }

            @Override
            public void onUploadError(SpeedTestError speedTestError, String errorMessage) {
                RepeatWrapper.this.clearRepeatTask(this, timer);
            }

            @Override
            public void onUploadProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onInterruption() {
            }
        };
        this.mSpeedTestSocket.addSpeedTestListener(speedTestListener);
        this.mRepeatWindows = repeatWindow;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RepeatWrapper.this.mSpeedTestSocket.removeSpeedTestListener(speedTestListener);
                RepeatWrapper.this.mSpeedTestSocket.forceStopTask();
                timer.cancel();
                timer.purge();
                RepeatWrapper.this.mRepeatFinished = true;
                if (repeatListener != null) {
                    repeatListener.onFinish(RepeatWrapper.this.mSpeedTestSocket.getLiveUploadReport());
                }
            }
        }, repeatWindow);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (repeatListener != null) {
                    repeatListener.onReport(RepeatWrapper.this.mSpeedTestSocket.getLiveUploadReport());
                }
            }
        }, reportPeriodMillis, (long)reportPeriodMillis);
        this.startUploadRepeat(hostname, port, uri, fileSizeOctet);
    }

    private void initRepeat(boolean isDownload) {
        this.mRepeatDownload = isDownload;
        this.mFirstDownloadRepeat = isDownload;
        this.mRepeatUpload = !isDownload;
        this.mFirstUploadRepeat = !isDownload;
        this.initRepeatVars();
    }

    private void initRepeatVars() {
        this.mRepeatRequestNum = 0;
        this.mRepeatPacketSize = BigDecimal.ZERO;
        this.mRepeatTempPckSize = 0L;
        this.mRepeatFinished = false;
        this.mStartDateRepeat = 0L;
        this.mRepeatTransferRateList = new ArrayList<BigDecimal>();
    }

    private void clearRepeatTask(ISpeedTestListener listener, Timer timer) {
        this.mSpeedTestSocket.removeSpeedTestListener(listener);
        if (timer != null) {
            timer.cancel();
            timer.purge();
        }
        this.mRepeatFinished = true;
        this.mSpeedTestSocket.closeSocket();
        this.mSpeedTestSocket.shutdownAndWait();
    }

    public boolean isFirstDownload() {
        return this.mFirstDownloadRepeat && this.mRepeatDownload;
    }

    public boolean isFirstUpload() {
        return this.mFirstUploadRepeat && this.mRepeatUpload;
    }

    public void setFirstDownloadRepeat(boolean state) {
        this.mFirstDownloadRepeat = state;
    }

    public void setStartDate(long timeStart) {
        this.mStartDateRepeat = timeStart;
    }

    public boolean isRepeatDownload() {
        return this.mRepeatDownload;
    }

    public void updatePacketSize(BigDecimal packetSize) {
        this.mRepeatPacketSize = this.mRepeatPacketSize.add(packetSize);
    }

    public void updateTempPacketSize(int read) {
        this.mRepeatTempPckSize += (long)read;
    }

    public boolean isRepeatUpload() {
        return this.mRepeatUpload;
    }

    public boolean isRepeat() {
        return this.mRepeatDownload || this.mRepeatUpload;
    }

    public void setFirstUploadRepeat(boolean state) {
        this.mFirstUploadRepeat = state;
    }
}

