/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.speedtest.RepeatWrapper;
import fr.bmartel.speedtest.SpeedTestConst;
import fr.bmartel.speedtest.SpeedTestReport;
import fr.bmartel.speedtest.SpeedTestTask;
import fr.bmartel.speedtest.inter.IRepeatListener;
import fr.bmartel.speedtest.inter.ISpeedTestListener;
import fr.bmartel.speedtest.inter.ISpeedTestSocket;
import fr.bmartel.speedtest.model.SpeedTestMode;
import fr.bmartel.speedtest.model.UploadStorageType;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SpeedTestSocket
implements ISpeedTestSocket {
    private int mScale = 4;
    private RoundingMode mRoundingMode = SpeedTestConst.DEFAULT_ROUNDING_MODE;
    private UploadStorageType mUploadStorageType = UploadStorageType.RAM_STORAGE;
    private final List<ISpeedTestListener> mListenerList = new ArrayList<ISpeedTestListener>();
    private int mUploadChunkSize = 65535;
    private int mSocketTimeout = 10000;
    private final RepeatWrapper mRepeatWrapper = new RepeatWrapper(this);
    private final SpeedTestTask mTask = new SpeedTestTask(this, this.mListenerList);

    private void initReportTask(int reportInterval, final boolean download) {
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!download) {
                    SpeedTestReport report = SpeedTestSocket.this.getLiveUploadReport();
                    for (ISpeedTestListener listener : SpeedTestSocket.this.mListenerList) {
                        listener.onUploadProgress(report.getProgressPercent(), report);
                    }
                } else {
                    SpeedTestReport report = SpeedTestSocket.this.getLiveDownloadReport();
                    for (ISpeedTestListener listener : SpeedTestSocket.this.mListenerList) {
                        listener.onDownloadProgress(report.getProgressPercent(), report);
                    }
                }
            }
        }, reportInterval, reportInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addSpeedTestListener(ISpeedTestListener listener) {
        this.mListenerList.add(listener);
    }

    @Override
    public void removeSpeedTestListener(ISpeedTestListener listener) {
        this.mListenerList.remove(listener);
    }

    @Override
    public void shutdownAndWait() {
        this.mTask.shutdownAndWait();
    }

    public void startFixedDownload(String hostname, int port, String uri, int maxDuration) {
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().schedule(new Runnable(){

            @Override
            public void run() {
                SpeedTestSocket.this.forceStopTask();
            }
        }, (long)maxDuration, TimeUnit.MILLISECONDS);
        this.startDownload(hostname, port, uri);
    }

    public void startFixedDownload(String hostname, int port, String uri, int maxDuration, int reportInterval) {
        this.initReportTask(reportInterval, true);
        this.mTask.setReportInterval(true);
        this.startFixedDownload(hostname, port, uri, maxDuration);
    }

    public void startDownload(String hostname, String uri) {
        this.startDownload(hostname, 80, uri);
    }

    public void startDownload(String hostname, String uri, int reportInterval) {
        this.startDownload(hostname, 80, uri, reportInterval);
    }

    public void startDownload(String hostname, int port, String uri, int reportInterval) {
        this.initReportTask(reportInterval, true);
        this.mTask.setReportInterval(true);
        this.startDownload(hostname, port, uri);
    }

    @Override
    public void startDownload(String hostname, int port, String uri) {
        this.mTask.startDownloadRequest(hostname, port, uri);
    }

    public void startFtpDownload(String hostname, String uri, int reportInterval) {
        this.initReportTask(reportInterval, true);
        this.mTask.setReportInterval(true);
        this.startFtpDownload(hostname, 21, uri, "anonymous", "");
    }

    public void startFtpFixedDownload(String hostname, String uri, int maxDuration, int reportInterval) {
        this.initReportTask(reportInterval, true);
        this.mTask.setReportInterval(true);
        this.startFtpFixedDownload(hostname, uri, maxDuration);
    }

    public void startFtpFixedDownload(String hostname, String uri, int maxDuration) {
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().schedule(new Runnable(){

            @Override
            public void run() {
                SpeedTestSocket.this.forceStopTask();
            }
        }, (long)maxDuration, TimeUnit.MILLISECONDS);
        this.startFtpDownload(hostname, 21, uri, "anonymous", "");
    }

    public void startFtpDownload(String hostname, String uri) {
        this.startFtpDownload(hostname, 21, uri, "anonymous", "");
    }

    public void startFtpDownload(String hostname, int port, String uri, String user, String password) {
        this.mTask.startFtpDownload(hostname, port, uri, user, password);
    }

    public void startFixedUpload(String hostname, int port, String uri, int fileSizeOctet, int maxDuration) {
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().schedule(new Runnable(){

            @Override
            public void run() {
                SpeedTestSocket.this.forceStopTask();
            }
        }, (long)maxDuration, TimeUnit.MILLISECONDS);
        this.startUpload(hostname, port, uri, fileSizeOctet);
    }

    public void startFixedUpload(String hostname, int port, String uri, int fileSizeOctet, int maxDuration, int reportInterval) {
        this.initReportTask(reportInterval, false);
        this.mTask.setReportInterval(true);
        this.startFixedUpload(hostname, port, uri, fileSizeOctet, maxDuration);
    }

    public void startFtpFixedUpload(String hostname, String uri, int fileSizeOctet, int maxDuration, int reportInterval) {
        this.initReportTask(reportInterval, false);
        this.mTask.setReportInterval(true);
        this.startFtpFixedUpload(hostname, uri, fileSizeOctet, maxDuration);
    }

    public void startFtpFixedUpload(String hostname, String uri, int fileSizeOctet, int maxDuration) {
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().schedule(new Runnable(){

            @Override
            public void run() {
                SpeedTestSocket.this.forceStopTask();
            }
        }, (long)maxDuration, TimeUnit.MILLISECONDS);
        this.startFtpUpload(hostname, 21, uri, fileSizeOctet, "anonymous", "");
    }

    public void startFtpUpload(String hostname, String uri, int fileSizeOctet, int reportInterval) {
        this.initReportTask(reportInterval, false);
        this.mTask.setReportInterval(true);
        this.startFtpUpload(hostname, 21, uri, fileSizeOctet, "anonymous", "");
    }

    public void startFtpUpload(String hostname, String uri, int fileSizeOctet) {
        this.startFtpUpload(hostname, 21, uri, fileSizeOctet, "anonymous", "");
    }

    public void startFtpUpload(String hostname, int port, String uri, int fileSizeOctet, String user, String password) {
        this.mTask.startFtpUpload(hostname, port, uri, fileSizeOctet, user, password);
    }

    public void startUpload(String hostname, String uri, int fileSizeOctet) {
        this.startUpload(hostname, 80, uri, fileSizeOctet);
    }

    public void startUpload(String hostname, String uri, int fileSizeOctet, int reportInterval) {
        this.startUpload(hostname, 80, uri, fileSizeOctet, reportInterval);
    }

    public void startUpload(String hostname, int port, String uri, int fileSizeOctet, int reportInterval) {
        this.initReportTask(reportInterval, false);
        this.mTask.setReportInterval(true);
        this.startUpload(hostname, port, uri, fileSizeOctet);
    }

    @Override
    public void startUpload(String hostname, int port, String uri, int fileSizeOctet) {
        this.mTask.writeUpload(hostname, port, uri, fileSizeOctet);
    }

    public void startDownloadRepeat(String hostname, String uri, int repeatWindow, int reportPeriodMillis, IRepeatListener repeatListener) {
        this.startDownloadRepeat(hostname, 80, uri, repeatWindow, reportPeriodMillis, repeatListener);
    }

    public void startDownloadRepeat(String hostname, int port, String uri, int repeatWindow, int reportPeriodMillis, IRepeatListener repeatListener) {
        this.mRepeatWrapper.startDownloadRepeat(hostname, port, uri, repeatWindow, reportPeriodMillis, repeatListener);
    }

    public void startUploadRepeat(String hostname, String uri, int repeatWindow, int reportPeriodMillis, int fileSizeOctet, IRepeatListener repeatListener) {
        this.startUploadRepeat(hostname, 80, uri, repeatWindow, reportPeriodMillis, fileSizeOctet, repeatListener);
    }

    public void startUploadRepeat(String hostname, int port, String uri, int repeatWindow, int reportPeriodMillis, int fileSizeOctet, IRepeatListener repeatListener) {
        this.mRepeatWrapper.startUploadRepeat(hostname, port, uri, repeatWindow, reportPeriodMillis, fileSizeOctet, repeatListener);
    }

    @Override
    public void forceStopTask() {
        this.mTask.forceStopTask();
        this.mTask.closeSocket();
        this.shutdownAndWait();
    }

    @Override
    public SpeedTestReport getLiveDownloadReport() {
        return this.mTask.getReport(SpeedTestMode.DOWNLOAD);
    }

    @Override
    public SpeedTestReport getLiveUploadReport() {
        return this.mTask.getReport(SpeedTestMode.UPLOAD);
    }

    @Override
    public void closeSocket() {
        this.mTask.closeSocket();
    }

    public SpeedTestMode getSpeedTestMode() {
        return this.mTask.getSpeedTestMode();
    }

    public void setSocketTimeout(int socketTimeoutMillis) {
        if (socketTimeoutMillis >= 0) {
            this.mSocketTimeout = socketTimeoutMillis;
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.mSocketTimeout;
    }

    @Override
    public int getUploadChunkSize() {
        return this.mUploadChunkSize;
    }

    @Override
    public RepeatWrapper getRepeatWrapper() {
        return this.mRepeatWrapper;
    }

    public void setUploadChunkSize(int uploadChunkSize) {
        this.mUploadChunkSize = uploadChunkSize;
    }

    public void setDefaultRoundingMode(RoundingMode roundingMode) {
        this.mRoundingMode = roundingMode;
    }

    public void setDefaultScale(int scale) {
        this.mScale = scale;
    }

    @Override
    public RoundingMode getDefaultRoundingMode() {
        return this.mRoundingMode;
    }

    @Override
    public int getDefaultScale() {
        return this.mScale;
    }

    @Override
    public UploadStorageType getUploadStorageType() {
        return this.mUploadStorageType;
    }

    @Override
    public void setUploadStorageType(UploadStorageType uploadStorageType) {
        this.mUploadStorageType = uploadStorageType;
    }

    public void clearListeners() {
        this.mListenerList.clear();
    }
}

