/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;

public class RandomGen {
    private final Random mRandom = new Random();

    public byte[] generateRandomArray(int length) {
        byte[] buffer = new byte[length];
        int iter = length / 64000;
        int remain = length % 64000;
        for (int i = 0; i < iter; ++i) {
            byte[] random = new byte[64000];
            this.mRandom.nextBytes(random);
            System.arraycopy(random, 0, buffer, i * 64000, 64000);
        }
        if (remain > 0) {
            byte[] random = new byte[remain];
            this.mRandom.nextBytes(random);
            System.arraycopy(random, 0, buffer, iter * 64000, remain);
        }
        return buffer;
    }

    public RandomAccessFile generateRandomFile(int length) throws IOException {
        File temp = File.createTempFile("speed-test-random", ".tmp");
        RandomAccessFile randomFile = new RandomAccessFile(temp.getAbsolutePath(), "rw");
        randomFile.setLength(length);
        int iter = length / 64000;
        int remain = length % 64000;
        for (int i = 0; i < iter; ++i) {
            byte[] random = new byte[64000];
            this.mRandom.nextBytes(random);
            randomFile.write(random);
        }
        if (remain > 0) {
            byte[] random = new byte[remain];
            this.mRandom.nextBytes(random);
            randomFile.write(random);
        }
        return randomFile;
    }
}

