/*
 * Decompiled with CFR 0.152.
 */
package ru.akman.maven.plugins.jlink;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import ru.akman.maven.plugins.BaseToolMojo;
import ru.akman.maven.plugins.CommandLineBuilder;
import ru.akman.maven.plugins.CommandLineOption;
import ru.akman.maven.plugins.jlink.Compress;
import ru.akman.maven.plugins.jlink.Compression;
import ru.akman.maven.plugins.jlink.DependencySet;
import ru.akman.maven.plugins.jlink.Endian;
import ru.akman.maven.plugins.jlink.HotSpot;
import ru.akman.maven.plugins.jlink.Launcher;
import ru.akman.maven.plugins.jlink.ModulePath;
import ru.akman.maven.plugins.jlink.PluginUtils;
import ru.akman.maven.plugins.jlink.ReleaseInfo;
import ru.akman.maven.plugins.jlink.Section;

@Mojo(name="jlink", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JlinkMojo
extends BaseToolMojo {
    private static final String TOOL_HOME_BIN = "bin";
    private static final String TOOL_NAME = "jlink";
    private static final String OPTS_FILE = "jlink.opts";
    private static final String ERROR_RESOLVE = "Error: Unable to resolve file path for {0} [{1}]";
    private static final String DESCRIPTOR_NAME = "module-info.class";
    private JavaVersion toolJavaVersion;
    private ResolvePathsResult<File> projectDependencies;
    private JavaModuleDescriptor mainModuleDescriptor;
    @Component
    private LocationManager locationManager;
    @Parameter
    private File toolhome;
    @Parameter(defaultValue="${project.build.directory}/jlink/mods")
    private File modsdir;
    @Parameter(defaultValue="${project.build.directory}/jlink/libs")
    private File libsdir;
    @Parameter
    private ModulePath modulepath;
    @Parameter
    private List<String> addmodules;
    @Parameter(defaultValue="${project.build.directory}/jlink/image")
    private File output;
    @Parameter
    private List<String> limitmodules;
    @Parameter
    private List<String> suggestproviders;
    @Parameter
    private File saveopts;
    @Parameter
    private String resourceslastsorter;
    @Parameter
    private File postprocesspath;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="false")
    private boolean bindservices;
    @Parameter
    private Launcher launcher;
    @Parameter(defaultValue="false")
    private boolean noheaderfiles;
    @Parameter(defaultValue="false")
    private boolean nomanpages;
    @Parameter(defaultValue="NATIVE")
    private Endian endian;
    @Parameter(defaultValue="false")
    private boolean ignoresigninginformation;
    @Parameter
    private List<String> disableplugins;
    @Parameter
    private Compress compress;
    @Parameter
    private List<String> includelocales;
    @Parameter
    private List<String> orderresources;
    @Parameter
    private List<String> excluderesources;
    @Parameter(defaultValue="false")
    private boolean stripdebug;
    @Parameter(defaultValue="false")
    private boolean stripjavadebugattributes;
    @Parameter(defaultValue="false")
    private boolean stripnativecommands;
    @Parameter(defaultValue="false")
    private boolean deduplegalnotices;
    @Parameter
    private List<String> excludefiles;
    @Parameter
    private Section excludejmodsection;
    @Parameter
    private File generatejliclasses;
    @Parameter
    private ReleaseInfo releaseinfo;
    @Parameter
    private HotSpot vm;

    private ResolvePathsResult<File> resolveDependencies() throws MojoExecutionException {
        Set artifacts = this.getProject().getArtifacts();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)PluginUtils.getArtifactSetDebugInfo(artifacts));
        }
        ArrayList<File> paths = new ArrayList<File>();
        paths.add(this.getOutputDir());
        paths.addAll(artifacts.stream().filter(a -> a != null && !"test".equals(a.getScope())).map(a -> a.getFile()).collect(Collectors.toList()));
        paths.addAll(this.getProject().getDependencies().stream().filter(d -> d != null && !StringUtils.isBlank((CharSequence)d.getSystemPath())).map(d -> new File(StringUtils.stripToEmpty((String)d.getSystemPath()))).collect(Collectors.toList()));
        ResolvePathsRequest request = ResolvePathsRequest.ofFiles(paths);
        File descriptorFile = this.getOutputDir().toPath().resolve(DESCRIPTOR_NAME).toFile();
        if (descriptorFile.exists() && !descriptorFile.isDirectory()) {
            request.setMainModuleDescriptor((Object)descriptorFile);
        }
        if (this.getToolHomeDirectory() != null) {
            request.setJdkHome((Object)this.getToolHomeDirectory());
        }
        try {
            return this.locationManager.resolvePaths(request);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error: Unable to resolve project dependencies", (Exception)ex);
        }
    }

    private JavaModuleDescriptor fetchMainModuleDescriptor() {
        JavaModuleDescriptor descriptor = this.projectDependencies.getMainModuleDescriptor();
        if (descriptor == null) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)"The main module descriptor not found");
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Found the main module descriptor: [{0}]", descriptor.name()));
        }
        return descriptor;
    }

    private Map<File, String> fetchPathExceptions() {
        return this.projectDependencies.getPathExceptions().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null).collect(Collectors.toMap(entry -> (File)entry.getKey(), entry -> PluginUtils.getThrowableCause((Throwable)entry.getValue())));
    }

    private List<File> fetchClasspathElements() {
        List<File> result = this.projectDependencies.getClasspathElements().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found classpath elements: " + result.size() + System.lineSeparator() + result.stream().map(file -> file.toString()).collect(Collectors.joining(System.lineSeparator()))));
        }
        return result;
    }

    private List<File> fetchModulepathElements() {
        List<File> result = this.projectDependencies.getModulepathElements().keySet().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found modulepath elements: " + result.size() + System.lineSeparator() + this.projectDependencies.getModulepathElements().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null).map(entry -> ((File)entry.getKey()).toString() + (String)(ModuleNameSource.FILENAME.equals(entry.getValue()) ? System.lineSeparator() + "[!] Detected 'requires' filename based automatic module" + System.lineSeparator() + "[!] Please don't publish this project to a public artifact repository" + System.lineSeparator() + (this.mainModuleDescriptor != null && this.mainModuleDescriptor.exports().isEmpty() ? "[!] APPLICATION" : "[!] LIBRARY") : "")).collect(Collectors.joining(System.lineSeparator()))));
        }
        return result;
    }

    private String getPathElements() {
        List<File> pathelements;
        String result = null;
        if (this.modulepath != null && (pathelements = this.modulepath.getPathElements()) != null && !pathelements.isEmpty()) {
            result = pathelements.stream().filter(Objects::nonNull).map(file -> file.toString()).collect(Collectors.joining(File.pathSeparator));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)PluginUtils.getPathElementsDebugInfo("PATHELEMENTS", pathelements));
                this.getLog().debug((CharSequence)result);
            }
        }
        return result;
    }

    private String getFileSets() throws MojoExecutionException {
        List<FileSet> filesets;
        String result = null;
        if (this.modulepath != null && (filesets = this.modulepath.getFileSets()) != null && !filesets.isEmpty()) {
            for (FileSet fileSet : filesets) {
                File fileSetDir;
                try {
                    fileSetDir = PluginUtils.normalizeFileSetBaseDir(this.getBaseDir(), fileSet);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error: Unable to resolve fileset", (Exception)ex);
                }
                result = Stream.of(this.getFileSetManager().getIncludedFiles(fileSet)).filter(fileName -> !StringUtils.isBlank((CharSequence)fileName)).map(fileName -> fileSetDir.toPath().resolve(StringUtils.stripToEmpty((String)fileName)).toString()).collect(Collectors.joining(File.pathSeparator));
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)PluginUtils.getFileSetDebugInfo("FILESET", fileSet, result));
            }
        }
        return result;
    }

    private String getDirSets() throws MojoExecutionException {
        List<FileSet> dirsets;
        String result = null;
        if (this.modulepath != null && (dirsets = this.modulepath.getDirSets()) != null && !dirsets.isEmpty()) {
            for (FileSet dirSet : dirsets) {
                File dirSetDir;
                try {
                    dirSetDir = PluginUtils.normalizeFileSetBaseDir(this.getBaseDir(), dirSet);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error: Unable to resolve dirset", (Exception)ex);
                }
                result = Stream.of(this.getFileSetManager().getIncludedDirectories(dirSet)).filter(dirName -> !StringUtils.isBlank((CharSequence)dirName)).map(dirName -> dirSetDir.toPath().resolve(StringUtils.stripToEmpty((String)dirName)).toString()).collect(Collectors.joining(File.pathSeparator));
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)PluginUtils.getFileSetDebugInfo("DIRSET", dirSet, result));
            }
        }
        return result;
    }

    private String getDependencySets() {
        List<DependencySet> dependencysets;
        String result = null;
        if (this.modulepath != null && (dependencysets = this.modulepath.getDependencySets()) != null && !dependencysets.isEmpty()) {
            for (DependencySet dependencySet : dependencysets) {
                result = this.getIncludedDependencies(dependencySet).stream().collect(Collectors.joining(File.pathSeparator));
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)PluginUtils.getDependencySetDebugInfo("DEPENDENCYSET", dependencySet, result));
            }
        }
        return result;
    }

    private Set<String> getIncludedDependencies(DependencySet depSet) {
        return this.projectDependencies.getPathElements().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null && this.filterDependency(depSet, (File)entry.getKey(), (JavaModuleDescriptor)entry.getValue())).map(entry -> ((File)entry.getKey()).toString()).collect(Collectors.toSet());
    }

    private Set<String> getExcludedDependencies(DependencySet depSet) {
        return this.projectDependencies.getPathElements().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null && !this.filterDependency(depSet, (File)entry.getKey(), (JavaModuleDescriptor)entry.getValue())).map(entry -> ((File)entry.getKey()).toString()).collect(Collectors.toSet());
    }

    private boolean filterDependency(DependencySet depSet, File file, JavaModuleDescriptor descriptor) {
        if (descriptor == null) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Missing module descriptor: " + file));
            }
        } else if (descriptor.isAutomatic() && this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found automatic module: " + file));
        }
        boolean isIncluded = false;
        if (depSet == null) {
            isIncluded = true;
            if (descriptor != null && descriptor.isAutomatic() && this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Included automatic module: " + file));
            }
            if (file.compareTo(this.getOutputDir()) == 0) {
                isIncluded = false;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Excluded output module: " + file));
                }
            }
        } else if (descriptor != null && descriptor.isAutomatic() && depSet.isAutomaticExcluded()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Excluded automatic module: " + file));
            }
        } else if (file.compareTo(this.getOutputDir()) == 0) {
            if (depSet.isOutputIncluded()) {
                isIncluded = true;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Included output module: " + file));
                }
            } else if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Excluded output module: " + file));
            }
        } else {
            boolean bl = isIncluded = this.matchesIncludes(depSet, file, descriptor) && !this.matchesExcludes(depSet, file, descriptor);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)PluginUtils.getDependencyDebugInfo(file, descriptor, isIncluded));
        }
        return isIncluded;
    }

    private boolean matchesIncludes(DependencySet depSet, File file, JavaModuleDescriptor descriptor) {
        String name = descriptor == null ? "" : descriptor.name();
        List<String> includes = depSet.getIncludes();
        List<String> includenames = depSet.getIncludeNames();
        boolean result = true;
        result = includenames == null || includenames.isEmpty() ? (includes == null || includes.isEmpty() ? true : this.pathMatches(includes, file.toPath())) : (includes == null || includes.isEmpty() ? this.nameMatches(includenames, name) : this.pathMatches(includes, file.toPath()) || this.nameMatches(includenames, name));
        return result;
    }

    private boolean matchesExcludes(DependencySet depSet, File file, JavaModuleDescriptor descriptor) {
        String name = descriptor == null ? "" : descriptor.name();
        List<String> excludes = depSet.getExcludes();
        List<String> excludenames = depSet.getExcludeNames();
        boolean result = false;
        result = excludenames == null || excludenames.isEmpty() ? (excludes == null || excludes.isEmpty() ? false : this.pathMatches(excludes, file.toPath())) : (excludes == null || excludes.isEmpty() ? this.nameMatches(excludenames, name) : this.pathMatches(excludes, file.toPath()) || this.nameMatches(excludenames, name));
        return result;
    }

    private boolean pathMatches(List<String> patterns, Path path) {
        for (String pattern : patterns) {
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(pattern);
            if (!pathMatcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    private boolean nameMatches(List<String> patterns, String name) {
        for (String pattern : patterns) {
            Pattern regexPattern = Pattern.compile(pattern);
            Matcher nameMatcher = regexPattern.matcher(name);
            if (!nameMatcher.matches()) continue;
            return true;
        }
        return false;
    }

    private void processModules(CommandLineBuilder cmdLine) throws MojoExecutionException {
        CommandLineOption opt = null;
        if (this.modulepath != null) {
            String dependencySets;
            String dirSets;
            String fileSets;
            StringBuilder path = new StringBuilder();
            String pathElements = this.getPathElements();
            if (!StringUtils.isBlank((CharSequence)pathElements)) {
                path.append(StringUtils.stripToEmpty((String)pathElements));
            }
            if (!StringUtils.isBlank((CharSequence)(fileSets = this.getFileSets()))) {
                if (path.length() != 0) {
                    path.append(File.pathSeparator);
                }
                path.append(StringUtils.stripToEmpty((String)fileSets));
            }
            if (!StringUtils.isBlank((CharSequence)(dirSets = this.getDirSets()))) {
                if (path.length() != 0) {
                    path.append(File.pathSeparator);
                }
                path.append(StringUtils.stripToEmpty((String)dirSets));
            }
            if (!StringUtils.isBlank((CharSequence)(dependencySets = this.getDependencySets()))) {
                if (path.length() != 0) {
                    path.append(File.pathSeparator);
                }
                path.append(StringUtils.stripToEmpty((String)dependencySets));
            }
            if (path.length() != 0) {
                opt = cmdLine.createOpt();
                opt.createArg().setValue("--module-path");
                opt.createArg().setValue(path.toString());
            }
        }
        if (this.includelocales != null && !this.includelocales.isEmpty()) {
            if (this.addmodules == null) {
                this.addmodules = new ArrayList<String>();
            }
            this.addmodules.add("jdk.localedata");
        }
        if (this.addmodules != null && !this.addmodules.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--add-modules");
            opt.createArg().setValue(this.addmodules.stream().collect(Collectors.joining(",")));
        }
    }

    private void processOptions(CommandLineBuilder cmdLine) throws MojoExecutionException {
        String launcherModule;
        String launcherCommand;
        CommandLineOption opt = null;
        opt = cmdLine.createOpt();
        opt.createArg().setValue("--output");
        try {
            opt.createArg().setValue(this.output.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--output", this.output.toString()), (Exception)ex);
        }
        if (this.saveopts != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--save-opts");
            try {
                opt.createArg().setValue(this.saveopts.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--save-opts", this.saveopts.toString()), (Exception)ex);
            }
        }
        if (this.postprocesspath != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--post-process-path");
            try {
                opt.createArg().setValue(this.postprocesspath.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--post-process-path", this.postprocesspath.toString()), (Exception)ex);
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.resourceslastsorter)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--resources-last-sorter");
            opt.createArg().setValue(StringUtils.stripToEmpty((String)this.resourceslastsorter));
        }
        if (this.verbose) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--verbose");
        }
        if (this.bindservices) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--bind-services");
        }
        if (this.noheaderfiles) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--no-header-files");
        }
        if (this.nomanpages) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--no-man-pages");
        }
        if (this.ignoresigninginformation) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--ignore-signing-information");
        }
        if (this.stripdebug) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--strip-debug");
        }
        if (this.stripjavadebugattributes) {
            if (this.toolJavaVersion.atLeast(JavaVersion.JAVA_13)) {
                opt = cmdLine.createOpt();
                opt.createArg().setValue("--strip-java-debug-attributes");
            } else {
                this.stripjavadebugattributes = false;
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)MessageFormat.format("Parameter [{0}] skiped, at least {1} is required to use it", "--strip-java-debug-attributes", JavaVersion.JAVA_13));
                }
            }
        }
        if (this.stripnativecommands) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--strip-native-commands");
        }
        if (this.deduplegalnotices) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--dedup-legal-notices=error-if-not-same-content");
        }
        if (this.limitmodules != null && !this.limitmodules.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--limit-modules");
            opt.createArg().setValue(this.limitmodules.stream().collect(Collectors.joining(",")));
        }
        if (this.suggestproviders != null && !this.suggestproviders.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--suggest-providers");
            opt.createArg().setValue(this.suggestproviders.stream().collect(Collectors.joining(",")));
        }
        if (this.endian != null && !this.endian.equals((Object)Endian.NATIVE)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--endian");
            opt.createArg().setValue(this.endian.toString().toLowerCase(Locale.ROOT));
        }
        if (this.disableplugins != null) {
            for (String plugin : this.disableplugins) {
                opt = cmdLine.createOpt();
                opt.createArg().setValue("--disable-plugin");
                opt.createArg().setValue(plugin);
            }
        }
        if (this.includelocales != null && !this.includelocales.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue(this.includelocales.stream().collect(Collectors.joining(",", "--include-locales=", "")));
        }
        if (this.excludejmodsection != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--exclude-jmod-section=" + this.excludejmodsection.toString().toLowerCase(Locale.ROOT));
        }
        if (this.generatejliclasses != null) {
            opt = cmdLine.createOpt();
            try {
                opt.createArg().setValue("--generate-jli-classes=@" + this.generatejliclasses.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "----generate-jli-classes", this.generatejliclasses.toString()), (Exception)ex);
            }
        }
        if (this.vm != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--vm=" + this.vm.toString().toLowerCase(Locale.ROOT));
        }
        if (this.launcher != null && !StringUtils.isBlank((CharSequence)(launcherCommand = StringUtils.stripToEmpty((String)this.launcher.getCommand()))) && !StringUtils.isBlank((CharSequence)(launcherModule = StringUtils.stripToEmpty((String)this.launcher.getMainModule())))) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--launcher");
            String launcherClass = StringUtils.stripToEmpty((String)this.launcher.getMainClass());
            if (StringUtils.isBlank((CharSequence)launcherClass)) {
                opt.createArg().setValue(launcherCommand + "=" + launcherModule);
            } else {
                opt.createArg().setValue(launcherCommand + "=" + launcherModule + "/" + launcherClass);
            }
        }
        if (this.compress != null) {
            Compression compression = this.compress.getCompression();
            List<String> filters = this.compress.getFilters();
            if (compression != null) {
                StringBuilder option = new StringBuilder("--compress=");
                option.append(compression.getValue());
                if (filters != null) {
                    option.append(filters.stream().collect(Collectors.joining(",", ":filter=", "")));
                }
                opt = cmdLine.createOpt();
                opt.createArg().setValue(option.toString());
            }
        }
        if (this.orderresources != null && !this.orderresources.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue(this.orderresources.stream().collect(Collectors.joining(",", "--order-resources=", "")));
        }
        if (this.excluderesources != null && !this.excluderesources.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue(this.excluderesources.stream().collect(Collectors.joining(",", "--exclude-resources=", "")));
        }
        if (this.excludefiles != null && !this.excludefiles.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue(this.excludefiles.stream().collect(Collectors.joining(",", "--exclude-files=", "")));
        }
        if (this.releaseinfo != null) {
            Map<String, String> dels;
            Map<String, String> adds;
            StringBuilder option = new StringBuilder();
            File releaseinfofile = this.releaseinfo.getFile();
            if (releaseinfofile != null) {
                option.append(releaseinfofile.toString());
            }
            if ((adds = this.releaseinfo.getAdds()) != null && !adds.entrySet().isEmpty()) {
                if (option.length() != 0) {
                    option.append(':');
                }
                option.append(adds.entrySet().stream().filter(add -> add != null && !StringUtils.isBlank((CharSequence)((CharSequence)add.getKey()))).map(add -> StringUtils.stripToEmpty((String)((String)add.getKey())) + "=" + StringUtils.stripToEmpty((String)((String)add.getValue()))).collect(Collectors.joining(":", "add:", "")));
            }
            if ((dels = this.releaseinfo.getDels()) != null && !dels.entrySet().isEmpty()) {
                if (option.length() != 0) {
                    option.append(':');
                }
                option.append(dels.entrySet().stream().filter(del -> del != null && !StringUtils.isBlank((CharSequence)((CharSequence)del.getKey()))).map(del -> StringUtils.stripToEmpty((String)((String)del.getKey()))).collect(Collectors.joining(":", "del:", "")));
            }
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--release-info=" + option.toString());
        }
    }

    private void copyFiles(List<File> files, File dir) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Copy files to: [{0}]", dir));
        }
        for (File file : files) {
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)MessageFormat.format("Skiped directory: [{0}]", file));
                    continue;
                }
                FileUtils.copyFileToDirectory((File)file, (File)dir);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)MessageFormat.format("Copied file: [{0}]", file));
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new MojoExecutionException(MessageFormat.format("Error: Unable to copy file: [{0}]", file), ex);
            }
        }
    }

    private void processLauncherScripts() throws MojoExecutionException {
        File winTemplate;
        if (this.launcher == null) {
            return;
        }
        String scriptName = StringUtils.stripToEmpty((String)this.launcher.getCommand());
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            return;
        }
        Path nixScript = this.output.toPath().resolve("bin/" + scriptName);
        Path winScript = this.output.toPath().resolve("bin/" + scriptName + ".bat");
        if (this.stripnativecommands) {
            block15: {
                block14: {
                    if (Files.exists(nixScript, new LinkOption[0]) && !Files.isDirectory(nixScript, new LinkOption[0])) {
                        try {
                            FileUtils.forceDelete((File)nixScript.toFile());
                        }
                        catch (IOException ex) {
                            if (!this.getLog().isWarnEnabled()) break block14;
                            this.getLog().warn((CharSequence)MessageFormat.format("Unable to delete launcher script: [{0}]", nixScript));
                        }
                    }
                }
                if (Files.exists(winScript, new LinkOption[0]) && !Files.isDirectory(winScript, new LinkOption[0])) {
                    try {
                        FileUtils.forceDelete((File)winScript.toFile());
                    }
                    catch (IOException ex) {
                        if (!this.getLog().isWarnEnabled()) break block15;
                        this.getLog().warn((CharSequence)MessageFormat.format("Unable to delete launcher script: [{0}]", winScript));
                    }
                }
            }
            return;
        }
        String moduleName = StringUtils.stripToEmpty((String)this.launcher.getMainModule());
        if (StringUtils.isEmpty((CharSequence)moduleName)) {
            return;
        }
        String mainClassName = StringUtils.stripToEmpty((String)this.launcher.getMainClass());
        StringBuilder mainName = new StringBuilder(moduleName);
        if (!StringUtils.isEmpty((CharSequence)mainClassName)) {
            mainName.append('/').append(mainClassName);
        }
        String args = StringUtils.stripToEmpty((String)this.launcher.getArgs());
        String jvmArgs = StringUtils.stripToEmpty((String)this.launcher.getJvmArgs());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(System.lineSeparator() + "Processing launcher scripts with following variables:" + System.lineSeparator() + MessageFormat.format("  - moduleName = [{0}]", moduleName) + System.lineSeparator() + MessageFormat.format("  - mainClassName = [{0}]", mainClassName) + System.lineSeparator() + MessageFormat.format("  - mainName = [{0}]", mainName.toString()) + System.lineSeparator() + MessageFormat.format("  - args = [{0}]", args) + System.lineSeparator() + MessageFormat.format("  - jvmArgs = [{0}]", jvmArgs)));
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("moduleName", moduleName);
        data.put("mainClassName", mainClassName);
        data.put("mainName", mainName.toString());
        data.put("args", args);
        data.put("jvmArgs", jvmArgs);
        File nixTemplate = this.launcher.getNixTemplate();
        if (nixTemplate != null && Files.exists(nixTemplate.toPath(), new LinkOption[0]) && !Files.isDirectory(nixTemplate.toPath(), new LinkOption[0])) {
            this.createLauncherScript(nixScript, nixTemplate.toPath(), data);
        }
        if ((winTemplate = this.launcher.getWinTemplate()) != null && Files.exists(winTemplate.toPath(), new LinkOption[0]) && !Files.isDirectory(winTemplate.toPath(), new LinkOption[0])) {
            this.createLauncherScript(winScript, winTemplate.toPath(), data);
        }
    }

    private void createLauncherScript(Path script, Path template, Map<String, String> data) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(System.lineSeparator() + MessageFormat.format("Fixing launcher script: [{0}]", script) + System.lineSeparator() + MessageFormat.format("with template: [{0}]", template)));
        }
        StringSubstitutor engine = new StringSubstitutor(data).setEnableUndefinedVariableException(true).setPreserveEscapes(true).setEscapeChar('\\');
        try {
            Files.write(script, (Iterable<? extends CharSequence>)Files.lines(template, this.getCharset()).map(line -> engine.replace(line).replace("\\$", "$")).collect(Collectors.toList()), this.getCharset(), new OpenOption[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Variable not found in the launcher template file: [{0}]", template), (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to write to the launcher script file: [{0}]", script), (Exception)ex);
        }
    }

    public void execute() throws MojoExecutionException {
        this.init(TOOL_NAME, this.toolhome, TOOL_HOME_BIN);
        this.toolJavaVersion = this.getToolJavaVersion();
        if (this.toolJavaVersion == null || !this.toolJavaVersion.atLeast(JavaVersion.JAVA_9)) {
            throw new MojoExecutionException(MessageFormat.format("Error: At least {0} is required to use [{1}]", JavaVersion.JAVA_9, TOOL_NAME));
        }
        try {
            FileUtils.forceMkdir((File)this.modsdir);
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to create mods directory: [{0}]", this.modsdir), ex);
        }
        try {
            FileUtils.forceMkdir((File)this.libsdir);
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to create libs directory: [{0}]", this.libsdir), ex);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Output directory: [{0}]", this.output));
        }
        if (this.output.exists() && this.output.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)this.output);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format("Error: Unable to delete image output directory: [{0}]", this.output), (Exception)ex);
            }
        }
        this.projectDependencies = this.resolveDependencies();
        this.mainModuleDescriptor = this.fetchMainModuleDescriptor();
        List<File> classpathElements = this.fetchClasspathElements();
        List<File> modulepathElements = this.fetchModulepathElements();
        Map<File, String> pathExceptions = this.fetchPathExceptions();
        if (!pathExceptions.isEmpty() && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)("Found path exceptions: " + pathExceptions.size() + System.lineSeparator() + pathExceptions.entrySet().stream().map(entry -> ((File)entry.getKey()).toString() + System.lineSeparator() + (String)entry.getValue()).collect(Collectors.joining(System.lineSeparator()))));
        }
        this.copyFiles(modulepathElements, this.modsdir);
        this.copyFiles(classpathElements, this.libsdir);
        CommandLineBuilder cmdLineBuilder = new CommandLineBuilder();
        cmdLineBuilder.setExecutable(this.getToolExecutable().toString());
        this.processOptions(cmdLineBuilder);
        this.processModules(cmdLineBuilder);
        ArrayList<String> optsLines = new ArrayList<String>();
        optsLines.add("# jlink");
        optsLines.addAll(cmdLineBuilder.buildOptionList());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)optsLines.stream().collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), "")));
        }
        Path cmdOptsPath = this.getBuildDir().toPath().resolve(OPTS_FILE);
        try {
            Files.write(cmdOptsPath, optsLines, this.getCharset(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to write command options to file: [{0}]", cmdOptsPath), (Exception)ex);
        }
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable(this.getToolExecutable().toString());
        cmdLine.createArg().setValue("@" + cmdOptsPath.toString());
        int exitCode = 0;
        try {
            exitCode = this.execCmdLine(cmdLine);
        }
        catch (CommandLineException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to execute [{0}] tool", TOOL_NAME), (Exception)((Object)ex));
        }
        if (exitCode != 0) {
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error((CharSequence)(System.lineSeparator() + "Command options was: " + System.lineSeparator() + optsLines.stream().collect(Collectors.joining(System.lineSeparator()))));
            }
            throw new MojoExecutionException(MessageFormat.format("Error: Tool execution failed [{0}] with exit code: {1}", TOOL_NAME, exitCode));
        }
        this.processLauncherScripts();
        try {
            FileUtils.forceDelete((File)cmdOptsPath.toFile());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to delete temporary file: [{0}]", cmdOptsPath), (Exception)ex);
        }
    }
}

