/*
 * Decompiled with CFR 0.152.
 */
package ru.akman.maven.plugins.jpackage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import ru.akman.maven.plugins.BaseToolMojo;
import ru.akman.maven.plugins.CommandLineBuilder;
import ru.akman.maven.plugins.CommandLineOption;
import ru.akman.maven.plugins.jpackage.DependencySet;
import ru.akman.maven.plugins.jpackage.Launcher;
import ru.akman.maven.plugins.jpackage.ModulePath;
import ru.akman.maven.plugins.jpackage.PackageType;
import ru.akman.maven.plugins.jpackage.PluginUtils;

@Mojo(name="jpackage", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JPackageMojo
extends BaseToolMojo {
    private static final String TOOL_HOME_BIN = "bin";
    private static final String TOOL_NAME = "jpackage";
    private static final String OPTS_FILE = "jpackage.opts";
    private static final String DESCRIPTOR_NAME = "module-info.class";
    private static final String PROPS_PREFIX = "launcher.";
    private static final String PROPS_SUFFIX = ".properties";
    private static final String SPACES_PATTERN = "\\s+";
    private static final char WRAP_CHAR = '\'';
    private static final String ERROR_RESOLVE = "Error: Unable to resolve file path for {0} [{1}]";
    private final List<File> tempFiles = new ArrayList<File>();
    private ResolvePathsResult<File> projectDependencies;
    private JavaModuleDescriptor mainModuleDescriptor;
    @Component
    private LocationManager locationManager;
    @Parameter
    private File toolhome;
    @Parameter(defaultValue="${project.build.directory}/jpackage")
    private File dest;
    @Parameter
    private File temp;
    @Parameter(defaultValue="PLATFORM")
    private PackageType type;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter
    private String appversion;
    @Parameter
    private String copyright;
    @Parameter
    private String description;
    @Parameter
    private String name;
    @Parameter
    private String vendor;
    @Parameter
    private File icon;
    @Parameter
    private File input;
    @Parameter
    private File runtimeimage;
    @Parameter
    private ModulePath modulepath;
    @Parameter
    private List<String> addmodules;
    @Parameter(defaultValue="false")
    private boolean bindservices;
    @Parameter
    private String module;
    @Parameter
    private String mainjar;
    @Parameter
    private String mainclass;
    @Parameter
    private String arguments;
    @Parameter
    private String javaoptions;
    @Parameter
    private List<Launcher> addlaunchers;
    @Parameter(defaultValue="false")
    private boolean winconsole;
    @Parameter
    private File appimage;
    @Parameter
    private List<File> fileassociations;
    @Parameter
    private String installdir;
    @Parameter
    private File licensefile;
    @Parameter
    private File resourcedir;
    @Parameter(defaultValue="false")
    private boolean windirchooser;
    @Parameter(defaultValue="false")
    private boolean winmenu;
    @Parameter
    private String winmenugroup;
    @Parameter(defaultValue="false")
    private boolean winperuserinstall;
    @Parameter(defaultValue="false")
    private boolean winshortcut;
    @Parameter
    private String winupgradeuuid;
    @Parameter
    private String macpackageidentifier;
    @Parameter
    private String macpackagename;
    @Parameter
    private String macpackagesigningprefix;
    @Parameter
    private boolean macsign;
    @Parameter
    private File macsigningkeychain;
    @Parameter
    private String macsigningkeyusername;
    @Parameter
    private String linuxpackagename;
    @Parameter
    private String linuxdebmaintainer;
    @Parameter
    private String linuxmenugroup;
    @Parameter
    private boolean linuxpackagedeps;
    @Parameter
    private String linuxrpmlicensetype;
    @Parameter
    private String linuxapprelease;
    @Parameter
    private String linuxappcategory;
    @Parameter
    private boolean linuxshortcut;

    private void processOptions(CommandLineBuilder cmdLine) throws MojoExecutionException {
        CommandLineOption opt = null;
        opt = cmdLine.createOpt();
        opt.createArg().setValue("--dest");
        try {
            opt.createArg().setValue(this.dest.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--dest", this.dest.toString()), (Exception)ex);
        }
        if (this.temp != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--temp");
            try {
                opt.createArg().setValue(this.temp.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--temp", this.temp.toString()), (Exception)ex);
            }
        }
        if (this.type != null && !this.type.equals((Object)PackageType.PLATFORM)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--type");
            switch (this.type) {
                case IMAGE: {
                    opt.createArg().setValue("app-image");
                    break;
                }
                case EXE: {
                    opt.createArg().setValue("exe");
                    break;
                }
                case MSI: {
                    opt.createArg().setValue("msi");
                    break;
                }
                case RPM: {
                    opt.createArg().setValue("rpm");
                    break;
                }
                case DEB: {
                    opt.createArg().setValue("deb");
                    break;
                }
                case PKG: {
                    opt.createArg().setValue("pkg");
                    break;
                }
                case DMG: {
                    opt.createArg().setValue("dmg");
                    break;
                }
            }
        }
        if (this.verbose) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--verbose");
        }
        if (!StringUtils.isBlank((CharSequence)this.appversion)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--app-version");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.appversion, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.copyright)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--copyright");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.copyright, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.description)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--description");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.description.replaceAll(SPACES_PATTERN, " "), '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.name)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--name");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.name, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.vendor)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--vendor");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.vendor, '\''));
        }
        if (this.icon != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--icon");
            try {
                opt.createArg().setValue(this.icon.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--icon", this.icon.toString()), (Exception)ex);
            }
        }
        if (this.input != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--input");
            try {
                opt.createArg().setValue(this.input.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--input", this.input.toString()), (Exception)ex);
            }
        }
        if (this.runtimeimage != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--runtime-image");
            try {
                opt.createArg().setValue(this.runtimeimage.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--runtime-image", this.runtimeimage.toString()), (Exception)ex);
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.module)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--module");
            opt.createArg().setValue(StringUtils.stripToEmpty((String)this.module));
        }
        if (!StringUtils.isBlank((CharSequence)this.mainjar)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--main-jar");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.mainjar, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.mainclass)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--main-class");
            opt.createArg().setValue(StringUtils.stripToEmpty((String)this.mainclass));
        }
        if (!StringUtils.isBlank((CharSequence)this.arguments)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--arguments");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.arguments, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.javaoptions)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--java-options");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.javaoptions, '\''));
        }
        if (this.addlaunchers != null && !this.addlaunchers.isEmpty()) {
            for (Launcher addlauncher : this.addlaunchers) {
                String name = StringUtils.stripToEmpty((String)addlauncher.getName());
                if (StringUtils.isBlank((CharSequence)name)) continue;
                File file = this.processLauncher(addlauncher);
                this.tempFiles.add(file);
                opt = cmdLine.createOpt();
                opt.createArg().setValue("--add-launcher");
                try {
                    opt.createArg().setValue(name + "=" + file.getCanonicalPath());
                }
                catch (IOException ex) {
                    throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--add-launcher", file.toString()), (Exception)ex);
                }
            }
        }
        if (this.winconsole) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--win-console");
        }
        if (this.appimage != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--app-image");
            try {
                opt.createArg().setValue(this.appimage.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--app-image", this.appimage.toString()), (Exception)ex);
            }
        }
        if (this.fileassociations != null) {
            for (File fileassociation : this.fileassociations) {
                if (fileassociation == null || StringUtils.isBlank((CharSequence)fileassociation.toString())) continue;
                opt = cmdLine.createOpt();
                opt.createArg().setValue("--file-associations");
                try {
                    opt.createArg().setValue(fileassociation.getCanonicalPath());
                }
                catch (IOException ex) {
                    throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--file-associations", fileassociation.toString()), (Exception)ex);
                }
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.installdir)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--install-dir");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.installdir, '\''));
        }
        if (this.licensefile != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--license-file");
            try {
                opt.createArg().setValue(this.licensefile.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--license-file", this.licensefile.toString()), (Exception)ex);
            }
        }
        if (this.resourcedir != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--resource-dir");
            try {
                opt.createArg().setValue(this.resourcedir.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--resource-dir", this.resourcedir.toString()), (Exception)ex);
            }
        }
        if (this.windirchooser) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--win-dir-chooser");
        }
        if (this.winmenu) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--win-menu");
        }
        if (!StringUtils.isBlank((CharSequence)this.winmenugroup)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--win-menu-group");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.winmenugroup, '\''));
        }
        if (this.winperuserinstall) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--win-per-user-install");
        }
        if (this.winshortcut) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--win-shortcut");
        }
        if (!StringUtils.isBlank((CharSequence)this.winupgradeuuid)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--win-upgrade-uuid");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.winupgradeuuid, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.macpackageidentifier)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--mac-package-identifier");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.macpackageidentifier, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.macpackagename)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--mac-package-name");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.macpackagename, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.macpackagesigningprefix)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--mac-package-signing-prefix");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.macpackagesigningprefix, '\''));
        }
        if (this.macsign) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--mac-sign");
        }
        if (this.macsigningkeychain != null) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--mac-signing-keychain");
            try {
                opt.createArg().setValue(this.macsigningkeychain.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format(ERROR_RESOLVE, "--mac-signing-keychain", this.macsigningkeychain.toString()), (Exception)ex);
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.macsigningkeyusername)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--mac-signing-key-user-name");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.macsigningkeyusername, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.linuxpackagename)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-package-name");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.linuxpackagename, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.linuxdebmaintainer)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-deb-maintainer");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.linuxdebmaintainer, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.linuxmenugroup)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-menu-group");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.linuxmenugroup, '\''));
        }
        if (this.linuxpackagedeps) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-package-deps");
        }
        if (!StringUtils.isBlank((CharSequence)this.linuxrpmlicensetype)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-rpm-license-type");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.linuxrpmlicensetype, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.linuxapprelease)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-app-release");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.linuxapprelease, '\''));
        }
        if (!StringUtils.isBlank((CharSequence)this.linuxappcategory)) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-app-category");
            opt.createArg().setValue(PluginUtils.wrapOpt(this.linuxappcategory, '\''));
        }
        if (this.linuxshortcut) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--linux-shortcut");
        }
    }

    private File processLauncher(Launcher launcher) throws MojoExecutionException {
        File file;
        Properties props;
        String name = launcher.getName();
        try {
            props = launcher.getProperties(this.getCharset());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to read properties for launcher: [{0}]", name), (Exception)ex);
        }
        try {
            file = Files.createTempFile(this.getBuildDir().toPath(), PROPS_PREFIX, PROPS_SUFFIX, new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to create temporary file for launcher: [{0}]", name), (Exception)ex);
        }
        try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), this.getCharset(), new OpenOption[0]);){
            props.store(bw, null);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to write temporary file for launcher: [{0}]", name), (Exception)ex);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(MessageFormat.format("Found additional launcher: [{0}]", name) + System.lineSeparator() + props.toString()));
        }
        return file;
    }

    private ResolvePathsResult<File> resolveDependencies() throws MojoExecutionException {
        Set artifacts = this.getProject().getArtifacts();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)PluginUtils.getArtifactSetDebugInfo(artifacts));
        }
        ArrayList<File> paths = new ArrayList<File>();
        paths.add(this.getOutputDir());
        paths.addAll(artifacts.stream().filter(a -> a != null && !"test".equals(a.getScope())).map(a -> a.getFile()).collect(Collectors.toList()));
        paths.addAll(this.getProject().getDependencies().stream().filter(d -> d != null && !StringUtils.isBlank((CharSequence)d.getSystemPath())).map(d -> new File(StringUtils.stripToEmpty((String)d.getSystemPath()))).collect(Collectors.toList()));
        ResolvePathsRequest request = ResolvePathsRequest.ofFiles(paths);
        File descriptorFile = this.getOutputDir().toPath().resolve(DESCRIPTOR_NAME).toFile();
        if (descriptorFile.exists() && !descriptorFile.isDirectory()) {
            request.setMainModuleDescriptor((Object)descriptorFile);
        }
        if (this.getToolHomeDirectory() != null) {
            request.setJdkHome((Object)this.getToolHomeDirectory());
        }
        try {
            return this.locationManager.resolvePaths(request);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error: Unable to resolve project dependencies", (Exception)ex);
        }
    }

    private JavaModuleDescriptor fetchMainModuleDescriptor() {
        JavaModuleDescriptor descriptor = this.projectDependencies.getMainModuleDescriptor();
        if (descriptor == null) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)"The main module descriptor not found");
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Found the main module descriptor: [{0}]", descriptor.name()));
        }
        return descriptor;
    }

    private Map<File, String> fetchPathExceptions() {
        return this.projectDependencies.getPathExceptions().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null).collect(Collectors.toMap(entry -> (File)entry.getKey(), entry -> PluginUtils.getThrowableCause((Throwable)entry.getValue())));
    }

    private List<File> fetchClasspathElements() {
        List<File> result = this.projectDependencies.getClasspathElements().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found classpath elements: " + result.size() + System.lineSeparator() + result.stream().map(file -> file.toString()).collect(Collectors.joining(System.lineSeparator()))));
        }
        return result;
    }

    private List<File> fetchModulepathElements() {
        List<File> result = this.projectDependencies.getModulepathElements().keySet().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found modulepath elements: " + result.size() + System.lineSeparator() + this.projectDependencies.getModulepathElements().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null).map(entry -> ((File)entry.getKey()).toString() + (String)(ModuleNameSource.FILENAME.equals(entry.getValue()) ? System.lineSeparator() + "[!] Detected 'requires' filename based automatic module" + System.lineSeparator() + "[!] Please don't publish this project to a public artifact repository" + System.lineSeparator() + (this.mainModuleDescriptor != null && this.mainModuleDescriptor.exports().isEmpty() ? "[!] APPLICATION" : "[!] LIBRARY") : "")).collect(Collectors.joining(System.lineSeparator()))));
        }
        return result;
    }

    private String getPathElements() {
        List<File> pathelements;
        String result = null;
        if (this.modulepath != null && (pathelements = this.modulepath.getPathElements()) != null && !pathelements.isEmpty()) {
            result = pathelements.stream().filter(Objects::nonNull).map(file -> file.toString()).collect(Collectors.joining(File.pathSeparator));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)PluginUtils.getPathElementsDebugInfo("PATHELEMENTS", pathelements));
                this.getLog().debug((CharSequence)result);
            }
        }
        return result;
    }

    private String getFileSets() throws MojoExecutionException {
        List<FileSet> filesets;
        String result = null;
        if (this.modulepath != null && (filesets = this.modulepath.getFileSets()) != null && !filesets.isEmpty()) {
            for (FileSet fileSet : filesets) {
                File fileSetDir;
                try {
                    fileSetDir = PluginUtils.normalizeFileSetBaseDir(this.getBaseDir(), fileSet);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error: Unable to resolve fileset", (Exception)ex);
                }
                result = Stream.of(this.getFileSetManager().getIncludedFiles(fileSet)).filter(fileName -> !StringUtils.isBlank((CharSequence)fileName)).map(fileName -> fileSetDir.toPath().resolve(StringUtils.stripToEmpty((String)fileName)).toString()).collect(Collectors.joining(File.pathSeparator));
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)PluginUtils.getFileSetDebugInfo("FILESET", fileSet, result));
            }
        }
        return result;
    }

    private String getDirSets() throws MojoExecutionException {
        List<FileSet> dirsets;
        String result = null;
        if (this.modulepath != null && (dirsets = this.modulepath.getDirSets()) != null && !dirsets.isEmpty()) {
            for (FileSet dirSet : dirsets) {
                File dirSetDir;
                try {
                    dirSetDir = PluginUtils.normalizeFileSetBaseDir(this.getBaseDir(), dirSet);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error: Unable to resolve dirset", (Exception)ex);
                }
                result = Stream.of(this.getFileSetManager().getIncludedDirectories(dirSet)).filter(dirName -> !StringUtils.isBlank((CharSequence)dirName)).map(dirName -> dirSetDir.toPath().resolve(StringUtils.stripToEmpty((String)dirName)).toString()).collect(Collectors.joining(File.pathSeparator));
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)PluginUtils.getFileSetDebugInfo("DIRSET", dirSet, result));
            }
        }
        return result;
    }

    private String getDependencySets() {
        List<DependencySet> dependencysets;
        String result = null;
        if (this.modulepath != null && (dependencysets = this.modulepath.getDependencySets()) != null && !dependencysets.isEmpty()) {
            for (DependencySet dependencySet : dependencysets) {
                result = this.getIncludedDependencies(dependencySet).stream().collect(Collectors.joining(File.pathSeparator));
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)PluginUtils.getDependencySetDebugInfo("DEPENDENCYSET", dependencySet, result));
            }
        }
        return result;
    }

    private Set<String> getIncludedDependencies(DependencySet depSet) {
        return this.projectDependencies.getPathElements().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null && this.filterDependency(depSet, (File)entry.getKey(), (JavaModuleDescriptor)entry.getValue())).map(entry -> ((File)entry.getKey()).toString()).collect(Collectors.toSet());
    }

    private Set<String> getExcludedDependencies(DependencySet depSet) {
        return this.projectDependencies.getPathElements().entrySet().stream().filter(entry -> entry != null && entry.getKey() != null && !this.filterDependency(depSet, (File)entry.getKey(), (JavaModuleDescriptor)entry.getValue())).map(entry -> ((File)entry.getKey()).toString()).collect(Collectors.toSet());
    }

    private boolean filterDependency(DependencySet depSet, File file, JavaModuleDescriptor descriptor) {
        if (descriptor == null) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Missing module descriptor: " + file));
            }
        } else if (descriptor.isAutomatic() && this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found automatic module: " + file));
        }
        boolean isIncluded = false;
        if (depSet == null) {
            isIncluded = true;
            if (descriptor != null && descriptor.isAutomatic() && this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Included automatic module: " + file));
            }
            if (file.compareTo(this.getOutputDir()) == 0) {
                isIncluded = false;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Excluded output module: " + file));
                }
            }
        } else if (descriptor != null && descriptor.isAutomatic() && depSet.isAutomaticExcluded()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Excluded automatic module: " + file));
            }
        } else if (file.compareTo(this.getOutputDir()) == 0) {
            if (depSet.isOutputIncluded()) {
                isIncluded = true;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Included output module: " + file));
                }
            } else if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Excluded output module: " + file));
            }
        } else {
            boolean bl = isIncluded = this.matchesIncludes(depSet, file, descriptor) && !this.matchesExcludes(depSet, file, descriptor);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)PluginUtils.getDependencyDebugInfo(file, descriptor, isIncluded));
        }
        return isIncluded;
    }

    private boolean matchesIncludes(DependencySet depSet, File file, JavaModuleDescriptor descriptor) {
        String name = descriptor == null ? "" : descriptor.name();
        List<String> includes = depSet.getIncludes();
        List<String> includenames = depSet.getIncludeNames();
        boolean result = true;
        result = includenames == null || includenames.isEmpty() ? (includes == null || includes.isEmpty() ? true : this.pathMatches(includes, file.toPath())) : (includes == null || includes.isEmpty() ? this.nameMatches(includenames, name) : this.pathMatches(includes, file.toPath()) || this.nameMatches(includenames, name));
        return result;
    }

    private boolean matchesExcludes(DependencySet depSet, File file, JavaModuleDescriptor descriptor) {
        String name = descriptor == null ? "" : descriptor.name();
        List<String> excludes = depSet.getExcludes();
        List<String> excludenames = depSet.getExcludeNames();
        boolean result = false;
        result = excludenames == null || excludenames.isEmpty() ? (excludes == null || excludes.isEmpty() ? false : this.pathMatches(excludes, file.toPath())) : (excludes == null || excludes.isEmpty() ? this.nameMatches(excludenames, name) : this.pathMatches(excludes, file.toPath()) || this.nameMatches(excludenames, name));
        return result;
    }

    private boolean pathMatches(List<String> patterns, Path path) {
        for (String pattern : patterns) {
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(pattern);
            if (!pathMatcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    private boolean nameMatches(List<String> patterns, String name) {
        for (String pattern : patterns) {
            Pattern regexPattern = Pattern.compile(pattern);
            Matcher nameMatcher = regexPattern.matcher(name);
            if (!nameMatcher.matches()) continue;
            return true;
        }
        return false;
    }

    private void processModules(CommandLineBuilder cmdLine) throws MojoExecutionException {
        CommandLineOption opt = null;
        if (this.modulepath != null) {
            String dependencySets;
            String dirSets;
            String fileSets;
            StringBuilder path = new StringBuilder();
            String pathElements = this.getPathElements();
            if (!StringUtils.isBlank((CharSequence)pathElements)) {
                path.append(StringUtils.stripToEmpty((String)pathElements));
            }
            if (!StringUtils.isBlank((CharSequence)(fileSets = this.getFileSets()))) {
                if (path.length() != 0) {
                    path.append(File.pathSeparator);
                }
                path.append(StringUtils.stripToEmpty((String)fileSets));
            }
            if (!StringUtils.isBlank((CharSequence)(dirSets = this.getDirSets()))) {
                if (path.length() != 0) {
                    path.append(File.pathSeparator);
                }
                path.append(StringUtils.stripToEmpty((String)dirSets));
            }
            if (!StringUtils.isBlank((CharSequence)(dependencySets = this.getDependencySets()))) {
                if (path.length() != 0) {
                    path.append(File.pathSeparator);
                }
                path.append(StringUtils.stripToEmpty((String)dependencySets));
            }
            if (path.length() != 0) {
                opt = cmdLine.createOpt();
                opt.createArg().setValue("--module-path");
                opt.createArg().setValue(path.toString());
            }
        }
        if (this.addmodules != null && !this.addmodules.isEmpty()) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--add-modules");
            opt.createArg().setValue(this.addmodules.stream().collect(Collectors.joining(",")));
        }
        if (this.bindservices) {
            opt = cmdLine.createOpt();
            opt.createArg().setValue("--bind-services");
        }
    }

    public void execute() throws MojoExecutionException {
        this.init(TOOL_NAME, this.toolhome, TOOL_HOME_BIN);
        JavaVersion toolJavaVersion = this.getToolJavaVersion();
        if (toolJavaVersion == null || !toolJavaVersion.atLeast(JavaVersion.JAVA_9)) {
            throw new MojoExecutionException(MessageFormat.format("Error: At least {0} is required to use [{1}]", JavaVersion.JAVA_9, TOOL_NAME));
        }
        if (this.temp != null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)MessageFormat.format("Temporary directory: [{0}]", this.temp));
            }
            if (this.temp.exists() && this.temp.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)this.temp);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException(MessageFormat.format("Error: Unable to delete temporary directory: [{0}]", this.temp), (Exception)ex);
                }
            }
        }
        this.projectDependencies = this.resolveDependencies();
        this.mainModuleDescriptor = this.fetchMainModuleDescriptor();
        Map<File, String> pathExceptions = this.fetchPathExceptions();
        if (!pathExceptions.isEmpty() && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)("Found path exceptions: " + pathExceptions.size() + System.lineSeparator() + pathExceptions.entrySet().stream().map(entry -> ((File)entry.getKey()).toString() + System.lineSeparator() + (String)entry.getValue()).collect(Collectors.joining(System.lineSeparator()))));
        }
        CommandLineBuilder cmdLineBuilder = new CommandLineBuilder();
        cmdLineBuilder.setExecutable(this.getToolExecutable().toString());
        this.processOptions(cmdLineBuilder);
        this.processModules(cmdLineBuilder);
        ArrayList<String> optsLines = new ArrayList<String>();
        optsLines.add("# jpackage");
        optsLines.addAll(cmdLineBuilder.buildOptionList());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)optsLines.stream().collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), "")));
        }
        Path cmdOptsPath = this.getBuildDir().toPath().resolve(OPTS_FILE);
        try {
            Files.write(cmdOptsPath, optsLines, this.getCharset(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to write command options to file: [{0}]", cmdOptsPath), (Exception)ex);
        }
        this.tempFiles.add(cmdOptsPath.toFile());
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable(this.getToolExecutable().toString());
        cmdLine.createArg().setValue("@" + cmdOptsPath.toString());
        int exitCode = 0;
        try {
            exitCode = this.execCmdLine(cmdLine);
        }
        catch (CommandLineException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to execute [{0}] tool", TOOL_NAME), (Exception)((Object)ex));
        }
        if (exitCode != 0) {
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error((CharSequence)(System.lineSeparator() + "Command options was: " + System.lineSeparator() + optsLines.stream().collect(Collectors.joining(System.lineSeparator()))));
            }
            throw new MojoExecutionException(MessageFormat.format("Error: Tool execution failed [{0}] with exit code: {1}", TOOL_NAME, exitCode));
        }
        for (File tempFile : this.tempFiles) {
            try {
                FileUtils.forceDelete((File)tempFile);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(MessageFormat.format("Error: Unable to delete temporary file: [{0}]", tempFile), (Exception)ex);
            }
        }
    }
}

