/*
 * Decompiled with CFR 0.152.
 */
package ru.akman.maven.plugins.jpackage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class Launcher {
    private String name;
    private File file;
    private String module;
    private String mainjar;
    private String mainclass;
    private String arguments;
    private String javaoptions;
    private String appversion;
    private File icon;
    private String winconsole;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getMainJar() {
        return this.mainjar;
    }

    public void setMainJar(String mainjar) {
        this.mainjar = mainjar;
    }

    public String getMainClass() {
        return this.mainclass;
    }

    public void setMainClass(String mainclass) {
        this.mainclass = mainclass;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getJavaOptions() {
        return this.javaoptions;
    }

    public void setJavaOptions(String javaoptions) {
        this.javaoptions = javaoptions;
    }

    public String getAppVersion() {
        return this.appversion;
    }

    public void setAppVersion(String appversion) {
        this.appversion = appversion;
    }

    public File getIcon() {
        return this.icon;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public boolean isWinConsole() {
        return String.valueOf(true).equals(this.winconsole);
    }

    public void setWinConsole(String winconsole) {
        this.winconsole = winconsole;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Properties getProperties(Charset charset) throws IOException {
        Properties props = new Properties();
        if (this.file != null) {
            try (BufferedReader br = Files.newBufferedReader(this.file.toPath(), charset);){
                props.load(br);
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.module)) {
            props.setProperty("module", this.module);
        }
        if (!StringUtils.isBlank((CharSequence)this.mainjar)) {
            props.setProperty("main-jar", this.mainjar);
        }
        if (!StringUtils.isBlank((CharSequence)this.mainclass)) {
            props.setProperty("main-class", this.mainclass);
        }
        if (!StringUtils.isBlank((CharSequence)this.arguments)) {
            props.setProperty("arguments", this.arguments);
        }
        if (!StringUtils.isBlank((CharSequence)this.javaoptions)) {
            props.setProperty("java-options", this.javaoptions);
        }
        if (!StringUtils.isBlank((CharSequence)this.appversion)) {
            props.setProperty("app-version", this.appversion);
        }
        if (this.icon != null) {
            props.setProperty("icon", this.icon.toString());
        }
        if (this.winconsole != null) {
            props.setProperty("win-console", String.valueOf(this.isWinConsole()));
        }
        return props;
    }
}

