/*
 * Decompiled with CFR 0.152.
 */
package ru.akman.maven.plugins.jpackage;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import ru.akman.maven.plugins.jpackage.DependencySet;

public final class PluginUtils {
    private PluginUtils() {
        throw new UnsupportedOperationException();
    }

    public static String wrapOpt(String str, char wrapWith) {
        return StringUtils.isBlank((CharSequence)str) ? "" : StringUtils.wrapIfMissing((String)StringUtils.stripToEmpty((String)str), (char)wrapWith);
    }

    public static String getThrowableCause(Throwable throwable) {
        return throwable.getCause() == null ? throwable.getMessage() : PluginUtils.getThrowableCause(throwable.getCause());
    }

    public static File normalizeFileSetBaseDir(File baseDir, FileSet fileSet) throws IOException {
        File fileSetDir;
        String dir = fileSet.getDirectory();
        if (dir == null) {
            dir = baseDir.getCanonicalPath();
        }
        if (!(fileSetDir = new File(dir)).isAbsolute()) {
            fileSetDir = new File(baseDir, dir);
        }
        fileSet.setDirectory(fileSetDir.getCanonicalPath());
        return fileSetDir;
    }

    public static String getArtifactSetDebugInfo(Set<Artifact> artifacts) {
        return "ARTIFACTS" + System.lineSeparator() + artifacts.stream().filter(Objects::nonNull).map(PluginUtils::getArtifactDebugInfo).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator();
    }

    public static String getArtifactDebugInfo(Artifact artifact) {
        return System.lineSeparator() + "[ " + artifact.getScope() + " ] " + artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion() + " - " + artifact.getFile().getName() + System.lineSeparator() + "  type: " + artifact.getType() + System.lineSeparator() + "  classifier: " + artifact.getClassifier() + System.lineSeparator() + "  optional: " + artifact.isOptional() + System.lineSeparator() + "  release: " + artifact.isRelease() + System.lineSeparator() + "  snapshot: " + artifact.isSnapshot() + System.lineSeparator() + "  resolved: " + artifact.isResolved();
    }

    public static String getPathElementsDebugInfo(String title, List<File> pathelements) {
        return System.lineSeparator() + title + System.lineSeparator() + pathelements.stream().filter(Objects::nonNull).map(file -> file.toString()).collect(Collectors.joining(System.lineSeparator()));
    }

    public static String getFileSetDebugInfo(String title, FileSet fileSet, String data) {
        return System.lineSeparator() + title + System.lineSeparator() + "directory: " + fileSet.getDirectory() + System.lineSeparator() + "followSymlinks: " + fileSet.isFollowSymlinks() + System.lineSeparator() + "includes:" + System.lineSeparator() + fileSet.getIncludes().stream().collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "excludes:" + System.lineSeparator() + fileSet.getExcludes().stream().collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "data:" + System.lineSeparator() + data;
    }

    public static String getDependencySetDebugInfo(String title, DependencySet depSet, String data) {
        StringBuilder result = new StringBuilder(System.lineSeparator());
        result.append(title).append(System.lineSeparator()).append("includeoutput: ").append(depSet.isOutputIncluded()).append(System.lineSeparator()).append("excludeautomatic: ").append(depSet.isAutomaticExcluded()).append(System.lineSeparator()).append("includes:");
        List<String> includes = depSet.getIncludes();
        if (includes != null) {
            result.append(System.lineSeparator()).append(includes.stream().collect(Collectors.joining(System.lineSeparator())));
        }
        result.append(System.lineSeparator()).append("includenames:");
        List<String> includenames = depSet.getIncludeNames();
        if (includenames != null) {
            result.append(System.lineSeparator()).append(includenames.stream().collect(Collectors.joining(System.lineSeparator())));
        }
        result.append(System.lineSeparator()).append("excludes:");
        List<String> excludes = depSet.getExcludes();
        if (excludes != null) {
            result.append(System.lineSeparator()).append(depSet.getExcludes().stream().collect(Collectors.joining(System.lineSeparator())));
        }
        result.append(System.lineSeparator()).append("excludenames:");
        List<String> excludenames = depSet.getExcludeNames();
        if (excludenames != null) {
            result.append(System.lineSeparator()).append(depSet.getExcludeNames().stream().collect(Collectors.joining(System.lineSeparator())));
        }
        result.append(System.lineSeparator()).append("data:").append(System.lineSeparator()).append(data);
        return result.toString();
    }

    public static String getDependencyDebugInfo(File file, JavaModuleDescriptor descriptor, boolean isIncluded) {
        StringBuilder result = new StringBuilder().append(System.lineSeparator()).append("included: ").append(isIncluded).append(System.lineSeparator()).append("file: ").append(file.getName()).append(System.lineSeparator()).append("path: ").append(file.toString());
        if (descriptor != null) {
            result.append(System.lineSeparator()).append("name: ").append(descriptor.name()).append(System.lineSeparator()).append("automatic: ").append(descriptor.isAutomatic()).append(System.lineSeparator()).append("requires: ").append(System.lineSeparator()).append(descriptor.requires().stream().filter(Objects::nonNull).map(requires -> requires.name() + " : " + requires.modifiers().stream().filter(Objects::nonNull).map(mod -> mod.toString()).collect(Collectors.joining(", ", "{ ", " }"))).collect(Collectors.joining(System.lineSeparator()))).append(System.lineSeparator()).append("exports: ").append(System.lineSeparator()).append(descriptor.exports().stream().filter(Objects::nonNull).map(exports -> exports.source() + " : " + (exports.targets() == null ? "{}" : exports.targets().stream().filter(Objects::nonNull).collect(Collectors.joining(", ", "{ ", " }")))).collect(Collectors.joining(System.lineSeparator()))).append(System.lineSeparator()).append("provides: ").append(System.lineSeparator()).append(descriptor.provides().stream().filter(Objects::nonNull).map(provides -> provides.service() + " : " + provides.providers().stream().filter(Objects::nonNull).collect(Collectors.joining(", ", "{ ", " }"))).collect(Collectors.joining(System.lineSeparator()))).append(System.lineSeparator()).append("uses: ").append(descriptor.uses().stream().filter(Objects::nonNull).collect(Collectors.joining(", ", "{ ", " }")));
        }
        return result.toString();
    }
}

