/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.tomcat.ConnectorConfiguration;
import org.apache.tomcat.WebAppConfiguration;

public final class Configuration {
    private static final String BASEDIR_VARIABLE = "${basedir}";
    private final ArrayList connectorConfigurations;
    private final Properties properties;
    private final List<WebAppConfiguration> webApps;
    private final String baseDir;
    private int poolMinThreads = 10;
    private int poolMaxThreads = 250;
    private int poolLowThreads = 50;
    private String sessionIdSuffix;
    private File tmpDir;
    private boolean joining = true;
    private int listenerPort;

    Configuration(String baseDir) {
        this.baseDir = baseDir;
        this.properties = new Properties();
        this.webApps = new ArrayList<WebAppConfiguration>();
        this.connectorConfigurations = new ArrayList();
    }

    public int getListenerPort() {
        return this.listenerPort;
    }

    public void setListenerPort(int listenerPort) {
        this.listenerPort = listenerPort;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public int getPoolMinThreads() {
        return this.poolMinThreads;
    }

    public int getPoolMaxThreads() {
        return this.poolMaxThreads;
    }

    public int getPoolLowThreads() {
        return this.poolLowThreads;
    }

    public int getCountConnectorConfigurations() {
        return this.connectorConfigurations.size();
    }

    public ConnectorConfiguration getConnectorConfiguration(int index) {
        return (ConnectorConfiguration)this.connectorConfigurations.get(index);
    }

    public String getSessionIdSuffix() {
        return this.sessionIdSuffix;
    }

    void setSessionIdSuffix(String suffix) {
        this.sessionIdSuffix = suffix;
    }

    void setPoolMinThreads(int poolMinThreads) {
        this.poolMinThreads = poolMinThreads;
    }

    void setPoolMaxThreads(int poolMaxThreads) {
        this.poolMaxThreads = poolMaxThreads;
    }

    void setPoolLowThreads(int poolLowThreads) {
        this.poolLowThreads = poolLowThreads;
    }

    void addProperty(String name, String value) {
        this.properties.put(name, this.normalize(value));
    }

    void addConnectorConfiguration(ConnectorConfiguration config) {
        this.connectorConfigurations.add(config);
    }

    void addWebApp(String contextPath, String webAppSourceDirectory, String jarsToSkip, String jarsToScan) {
        this.webApps.add(new WebAppConfiguration(contextPath, this.normalize(webAppSourceDirectory), jarsToSkip, jarsToScan));
    }

    public List<WebAppConfiguration> getWebApps() {
        return this.webApps;
    }

    String normalize(String path) {
        int index = path.indexOf(BASEDIR_VARIABLE);
        if (index != -1) {
            path = path.substring(0, index) + this.baseDir + path.substring(index + BASEDIR_VARIABLE.length());
        }
        return path;
    }

    public void updateSystemProperties() {
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = this.properties.getProperty(key);
            System.setProperty(key, value);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Configuration:\n");
        buffer.append("==============================================\n");
        buffer.append("Base directory    = ");
        buffer.append(this.baseDir);
        buffer.append('\n');
        buffer.append("ThreadPool:\n");
        buffer.append("  min Threads     = ");
        buffer.append(this.poolMinThreads);
        buffer.append('\n');
        buffer.append("  max Threads     = ");
        buffer.append(this.poolMaxThreads);
        buffer.append('\n');
        buffer.append("  low Threads     = ");
        buffer.append(this.poolLowThreads);
        buffer.append('\n');
        if (this.sessionIdSuffix != null) {
            buffer.append("SessionId suffix  = ");
            buffer.append(this.sessionIdSuffix);
            buffer.append('\n');
        }
        if (this.properties.size() > 0) {
            buffer.append("System properties:\n");
            Enumeration<Object> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = this.properties.getProperty(key);
                buffer.append("  ");
                buffer.append(key);
                buffer.append(" = ");
                buffer.append(value);
                buffer.append('\n');
            }
        }
        buffer.append("Connectors:\n");
        int size = this.connectorConfigurations.size();
        for (int i = 0; i < size; ++i) {
            ConnectorConfiguration connectorConfiguration = (ConnectorConfiguration)this.connectorConfigurations.get(i);
            buffer.append(i + 1);
            buffer.append(" Connector:\n");
            buffer.append("  Clazz           = ");
            buffer.append(connectorConfiguration.getConnectorClazz());
            buffer.append('\n');
            buffer.append("  Port            = ");
            buffer.append(connectorConfiguration.getConnectorPort());
            buffer.append('\n');
            buffer.append("  Max Idle Time   = ");
            buffer.append(connectorConfiguration.getMaxIdleTime());
            buffer.append('\n');
        }
        buffer.append("SERVER PROPS: \n");
        buffer.append("  Server is joining   = ");
        buffer.append(this.isJoining());
        buffer.append('\n');
        if (this.listenerPort != 0) {
            buffer.append("  Server ist im StopListenerMode auf Port = ");
            buffer.append(this.listenerPort);
            buffer.append("\n");
        }
        buffer.append("==============================================\n");
        buffer.append("\n");
        buffer.append("========Folgende Webapplikationen=============\n");
        buffer.append("==============================================\n");
        if (this.webApps != null) {
            buffer.append("Webapps properties:\n");
            for (WebAppConfiguration webAppConfiguration : this.webApps) {
                String key = webAppConfiguration.getContextPath();
                String value = webAppConfiguration.getWebAppSourceDirectory();
                buffer.append("ContextRoot: ");
                buffer.append(key);
                buffer.append(" | Basedir: ");
                buffer.append(value);
                buffer.append('\n');
            }
        }
        buffer.append("==============================================\n");
        return buffer.toString();
    }

    public boolean isJoining() {
        return this.joining;
    }

    public void setJoining(boolean joining) {
        this.joining = joining;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }
}

