/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tomcat.Configuration;
import org.apache.tomcat.ConnectorConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ConfigurationReader {
    private ConfigurationReader() {
    }

    public static Configuration readConfiguration(String configName) {
        try {
            File baseDir = new File(".");
            File configFile = new File(configName);
            System.out.println("--------" + configFile.getAbsolutePath());
            if (!configFile.getCanonicalFile().exists()) {
                throw new RuntimeException("Kann File " + configFile.getAbsolutePath() + " nicht finden ...");
            }
            baseDir = configFile.getCanonicalFile().getParentFile();
            Configuration configuration = new Configuration(baseDir.getCanonicalPath());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(new FileInputStream(configFile.getCanonicalFile()));
            Document doc = builder.parse(source);
            ConfigurationReader.readConfiguration(doc, configuration);
            return configuration;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void readConfiguration(Document doc, Configuration configuration) {
        String listenerPort;
        File directory;
        Node jettyNode = ConfigurationReader.findSubNode(doc, "config");
        if (jettyNode == null) {
            throw new IllegalArgumentException("Could not find configuration");
        }
        Node connectorsNode = ConfigurationReader.findSubNode(jettyNode, "connectors");
        if (connectorsNode != null) {
            NodeList connectorNodes = connectorsNode.getChildNodes();
            int size = connectorNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node implNode;
                Node connectorNode = connectorNodes.item(i);
                if (!"connector".equals(connectorNode.getNodeName())) continue;
                ConnectorConfiguration connectorConfig = new ConnectorConfiguration();
                NamedNodeMap attrMap = connectorNode.getAttributes();
                if (attrMap != null && (implNode = attrMap.getNamedItem("implementation")) != null) {
                    connectorConfig.setConnectorClazz(implNode.getNodeValue().trim());
                }
                connectorConfig.setConnectorPort(Integer.parseInt(ConfigurationReader.getProperty(connectorNode, "port")));
                if (ConfigurationReader.getProperty(connectorNode, "adress") != null) {
                    connectorConfig.setConnectorAdress(ConfigurationReader.getProperty(connectorNode, "adress"));
                }
                connectorConfig.setMaxIdleTime(Integer.parseInt(ConfigurationReader.getProperty(connectorNode, "maxIdleTime")));
                String secureStr = ConfigurationReader.getProperty(connectorNode, "secure");
                if (secureStr != null) {
                    connectorConfig.setSecure(Boolean.parseBoolean(secureStr));
                }
                connectorConfig.setKeystoreFile(ConfigurationReader.getProperty(connectorNode, "keystoreFile"));
                connectorConfig.setKeystorePass(ConfigurationReader.getProperty(connectorNode, "keystorePass"));
                connectorConfig.setKeyAlias(ConfigurationReader.getProperty(connectorNode, "keyAlias"));
                connectorConfig.setTruststoreFile(ConfigurationReader.getProperty(connectorNode, "truststoreFile"));
                connectorConfig.setTruststorePass(ConfigurationReader.getProperty(connectorNode, "truststorePass"));
                connectorConfig.setClientAuth(ConfigurationReader.getProperty(connectorNode, "clientAuth"));
                connectorConfig.setSslProtocol(ConfigurationReader.getProperty(connectorNode, "sslProtocol"));
                configuration.addConnectorConfiguration(connectorConfig);
            }
        } else {
            configuration.addConnectorConfiguration(new ConnectorConfiguration());
        }
        Node tmpDir = ConfigurationReader.findSubNode(jettyNode, "tmpDir");
        if (tmpDir != null && (directory = new File(tmpDir.getFirstChild().getNodeValue().trim())).exists() && directory.isDirectory()) {
            configuration.setTmpDir(directory);
        }
        if (ConfigurationReader.isNumeric(listenerPort = ConfigurationReader.getProperty(jettyNode, "stoplistenerport"))) {
            configuration.setListenerPort(Integer.parseInt(listenerPort));
        }
        configuration.setJoining(new Boolean(ConfigurationReader.getProperty(jettyNode, "join")));
        configuration.setSessionIdSuffix(ConfigurationReader.getProperty(jettyNode, "sessionid-suffix"));
        Node[] systemProperties = ConfigurationReader.getSubNodes(jettyNode, "systemProperties", "systemProperty");
        for (int i = 0; i < systemProperties.length; ++i) {
            Node valueNode = ConfigurationReader.findSubNode(systemProperties[i], "value");
            Node nameNode = ConfigurationReader.findSubNode(systemProperties[i], "name");
            if (valueNode == null || nameNode == null) continue;
            configuration.addProperty(nameNode.getFirstChild().getNodeValue().trim(), valueNode.getFirstChild().getNodeValue().trim());
        }
        Node[] webApplications = ConfigurationReader.getSubNodes(jettyNode, "webApps", "webApp");
        if (webApplications == null || webApplications.length == 0) {
            configuration.addWebApp(ConfigurationReader.getProperty(jettyNode, "contextPath"), ConfigurationReader.getProperty(jettyNode, "webAppSourceDirectory"), ConfigurationReader.getProperty(jettyNode, "jarsToSkip"), ConfigurationReader.getProperty(jettyNode, "jarsToScan"));
        } else {
            for (int i = 0; i < webApplications.length; ++i) {
                Node contextPathNode = ConfigurationReader.findSubNode(webApplications[i], "contextPath");
                Node webAppSourceDirectoryNode = ConfigurationReader.findSubNode(webApplications[i], "webAppSourceDirectory");
                if (contextPathNode == null || webAppSourceDirectoryNode == null) continue;
                configuration.addWebApp(ConfigurationReader.getProperty(webApplications[i], "contextPath"), ConfigurationReader.getProperty(webApplications[i], "webAppSourceDirectory"), ConfigurationReader.getProperty(webApplications[i], "jarsToSkip"), ConfigurationReader.getProperty(webApplications[i], "jarsToScan"));
            }
        }
    }

    private static String getProperty(Node jettyNode, String nodeName) {
        Node node = ConfigurationReader.findSubNode(jettyNode, nodeName);
        if (node != null) {
            return node.getFirstChild().getNodeValue().trim();
        }
        return null;
    }

    private static Node[] getSubNodes(Node jettyNode, String nodeName, String subNodeName) {
        Node[] result = new Node[]{};
        Node propertiesNode = ConfigurationReader.findSubNode(jettyNode, nodeName);
        if (propertiesNode != null) {
            NodeList propertyNodes = propertiesNode.getChildNodes();
            int size = propertyNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node propertyNode = propertyNodes.item(i);
                if (!subNodeName.equals(propertyNode.getNodeName())) continue;
                int arrayLength = Array.getLength(result);
                Node[] tmp = new Node[arrayLength];
                System.arraycopy(result, 0, tmp, 0, arrayLength);
                result = new Node[arrayLength + 1];
                System.arraycopy(tmp, 0, result, 0, tmp.length);
                Array.set(result, arrayLength, propertyNode);
            }
        }
        return result;
    }

    private static Node findSubNode(Node parent, String subNodeName) {
        NodeList list = parent.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!subNodeName.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

